/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.converter.AlternateAnnotationCreatorVisitor;
import com.google.gwt.resources.converter.DefCollectorVisitor;
import com.google.gwt.resources.converter.ElseNodeCreator;
import com.google.gwt.resources.converter.GssGenerationVisitor;
import com.google.gwt.resources.converter.UndefinedConstantVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.io.FileWriteMode;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;

public class Css2Gss {
    private final URL cssFile;
    private final TreeLogger treeLogger;
    private final boolean lenient;
    private PrintWriter printWriter;
    private Map<String, String> defNameMapping;
    private Predicate<String> simpleBooleanConditionPredicate;
    private final Set<URL> scopeFiles;

    public Css2Gss(String filePath) throws MalformedURLException {
        this(new File(filePath).toURI().toURL(), false);
    }

    public Css2Gss(URL resource, boolean lenient) {
        this(resource, lenient, Predicates.alwaysFalse(), new HashSet<URL>());
    }

    public Css2Gss(URL resource, boolean lenient, Predicate<String> simpleBooleanConditionPredicate, Set<URL> scopeFiles) {
        this.cssFile = resource;
        this.printWriter = new PrintWriter(System.err);
        PrintWriterTreeLogger printWriterTreeLogger = new PrintWriterTreeLogger(this.printWriter);
        printWriterTreeLogger.setMaxDetail(TreeLogger.Type.WARN);
        this.treeLogger = printWriterTreeLogger;
        this.lenient = lenient;
        this.simpleBooleanConditionPredicate = simpleBooleanConditionPredicate;
        this.scopeFiles = scopeFiles;
    }

    public Css2Gss(URL fileUrl, TreeLogger treeLogger, boolean lenient, Predicate<String> simpleBooleanConditionPredicate, Set<URL> scopeFiles) {
        this.cssFile = fileUrl;
        this.treeLogger = treeLogger;
        this.lenient = lenient;
        this.simpleBooleanConditionPredicate = simpleBooleanConditionPredicate;
        this.scopeFiles = scopeFiles;
    }

    public Css2Gss(URL url, TreeLogger logger, boolean lenientConversion, Predicate<String> simpleBooleanConditionPredicate) {
        this(url, logger, lenientConversion, simpleBooleanConditionPredicate, new HashSet<URL>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toGss() throws UnableToCompleteException {
        try {
            CssStylesheet sheet = GenerateCssAst.exec(this.treeLogger, this.cssFile);
            DefCollectorVisitor defCollectorVisitor = new DefCollectorVisitor(this.lenient, this.treeLogger);
            defCollectorVisitor.accept(sheet);
            this.defNameMapping = defCollectorVisitor.getDefMapping();
            this.addScopeDefs(this.scopeFiles, this.defNameMapping);
            new UndefinedConstantVisitor(new HashSet<String>(this.defNameMapping.values()), this.lenient, this.treeLogger).accept(sheet);
            new ElseNodeCreator().accept(sheet);
            new AlternateAnnotationCreatorVisitor().accept(sheet);
            GssGenerationVisitor gssGenerationVisitor = new GssGenerationVisitor((TextOutput)new DefaultTextOutput(false), this.defNameMapping, this.lenient, this.treeLogger, this.simpleBooleanConditionPredicate);
            gssGenerationVisitor.accept(sheet);
            String string = gssGenerationVisitor.getContent();
            return string;
        }
        finally {
            if (this.printWriter != null) {
                this.printWriter.flush();
            }
        }
    }

    private void addScopeDefs(Set<URL> scopeFiles, Map<String, String> defNameMapping) throws UnableToCompleteException {
        for (URL fileName : scopeFiles) {
            CssStylesheet sheet = GenerateCssAst.exec(this.treeLogger, fileName);
            DefCollectorVisitor defCollectorVisitor = new DefCollectorVisitor(this.lenient, this.treeLogger);
            defCollectorVisitor.accept(sheet);
            defNameMapping.putAll(defCollectorVisitor.getDefMapping());
        }
    }

    public Map<String, String> getDefNameMapping() {
        return this.defNameMapping;
    }

    public static void main(String ... args) {
        Options options = Options.parseOrQuit(args);
        if (options.singleFile) {
            try {
                System.out.println(Css2Gss.convertFile(options.resource, options.simpleBooleanConditions, options.scopeFiles));
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        Collection filesToConvert = FileUtils.listFiles((File)options.resource, (String[])new String[]{"css"}, (boolean)options.recurse);
        for (File cssFile : filesToConvert) {
            try {
                if (Css2Gss.doesCorrespondingGssFileExists(cssFile)) {
                    String string = String.valueOf(cssFile.getAbsolutePath());
                    System.out.println(string.length() != 0 ? "GSS file already exists - will not convert, file: ".concat(string) : new String("GSS file already exists - will not convert, file: "));
                    continue;
                }
                String gss = Css2Gss.convertFile(cssFile, options.simpleBooleanConditions, options.scopeFiles);
                Css2Gss.writeGss(gss, cssFile);
                String string = String.valueOf(cssFile.getAbsolutePath());
                System.out.println(string.length() != 0 ? "Converted ".concat(string) : new String("Converted "));
            }
            catch (Exception e) {
                String string = String.valueOf(cssFile.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Failed to convert ".concat(string) : new String("Failed to convert "));
                e.printStackTrace();
            }
        }
    }

    private static boolean doesCorrespondingGssFileExists(File cssFile) {
        File gssFile = Css2Gss.getCorrespondingGssFile(cssFile);
        return gssFile.exists();
    }

    private static File getCorrespondingGssFile(File cssFile) {
        String name = cssFile.getName();
        assert (name.endsWith(".css"));
        name = String.valueOf(name.substring(0, name.length() - ".css".length())).concat(".gss");
        return new File(cssFile.getParentFile(), name);
    }

    private static void writeGss(String gss, File cssFile) throws IOException {
        File gssFile = Css2Gss.getCorrespondingGssFile(cssFile);
        Files.asCharSink(gssFile, Charsets.UTF_8, new FileWriteMode[0]).write(gss);
    }

    private static String convertFile(File resource, Set<String> simpleBooleanConditions, Set<URL> scopeFiles) throws MalformedURLException, UnableToCompleteException {
        Predicate<String> simpleConditionPredicate = simpleBooleanConditions != null ? Predicates.in(simpleBooleanConditions) : Predicates.alwaysFalse();
        return new Css2Gss(resource.toURI().toURL(), false, simpleConditionPredicate, scopeFiles).toGss();
    }

    private static void printUsage() {
        System.err.println("Usage :");
        String string = String.valueOf(Css2Gss.class.getName());
        System.err.println(new StringBuilder(35 + String.valueOf(string).length()).append("java ").append(string).append(" [Options] [file or directory]").toString());
        System.err.println("Options:");
        System.err.println(" -r -> Recursively convert all css files on the given directory(leaves .css files in place)");
        System.err.println(" -condition list_of_condition -> Specify a comma-separated list of variables that are used in conditionals and that will be mapped to configuration properties. The converter will not use the is() function when it will convert these conditions");
        System.err.println(" -scope list_of_files -> Specify a comma-separated list of css files to be used in this conversion to determine all defined variables");
    }

    private static interface ArgumentConsumer {
        public boolean consume(Options var1, String var2);
    }

    static class Options {
        static final Map<String, ArgumentConsumer> argumentConsumers = new LinkedHashMap<String, ArgumentConsumer>();
        boolean recurse;
        boolean singleFile;
        ImmutableSet<URL> scopeFiles = ImmutableSet.of();
        File resource;
        Set<String> simpleBooleanConditions;
        File baseDir;
        private String scope;

        Options() {
        }

        private static Options parseOrQuit(String[] args) {
            if (!Options.validateArgs(args)) {
                Options.quitEarly(null);
            }
            Options options = new Options();
            int index = 0;
            while (index < args.length - 1) {
                boolean skipNextArg;
                String arg = args[index++];
                String nextArg = index < args.length - 1 ? args[index] : null;
                ArgumentConsumer consumer = argumentConsumers.get(arg);
                if (consumer == null) {
                    String string = String.valueOf(arg);
                    Options.quitEarly(string.length() != 0 ? "Unknown argument: ".concat(string) : new String("Unknown argument: "));
                }
                if (!(skipNextArg = consumer.consume(options, nextArg))) continue;
                ++index;
            }
            if (index == args.length) {
                Options.quitEarly("Missing file or directly as last parameter");
            }
            if (options.scope != null) {
                ImmutableSet<String> scopeFileSet = FluentIterable.from(Splitter.on(',').split(options.scope)).toSet();
                HashSet<URL> set = new HashSet<URL>();
                for (String scopeFile : scopeFileSet) {
                    File file = null;
                    file = options.baseDir != null && !scopeFile.startsWith(File.separator) ? new File(options.baseDir, scopeFile).getAbsoluteFile() : new File(scopeFile).getAbsoluteFile();
                    if (!file.exists() && !file.isFile()) {
                        String string = String.valueOf(file.getAbsolutePath());
                        Options.quitEarly(new StringBuilder(32 + String.valueOf(string).length()).append("The scope file '").append(string).append("' does not exist").toString());
                    }
                    try {
                        set.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        Options.quitEarly(new StringBuilder(37 + String.valueOf(scopeFile).length()).append("Can not create url for scope file: '").append(scopeFile).append("'").toString());
                    }
                }
                options.scopeFiles = ImmutableSet.copyOf(set);
            }
            options.resource = options.baseDir != null && !args[index].startsWith(File.separator) ? new File(options.baseDir, args[index]).getAbsoluteFile() : new File(args[index]).getAbsoluteFile();
            boolean bl = options.singleFile = !options.resource.isDirectory();
            if (!options.resource.exists()) {
                String string = String.valueOf(options.resource.getAbsolutePath());
                Options.quitEarly(string.length() != 0 ? "File or Directory does not exists: ".concat(string) : new String("File or Directory does not exists: "));
            }
            if (options.recurse && !options.resource.isDirectory()) {
                Options.quitEarly("When using -r the last parameter needs to be a directory");
            }
            return options;
        }

        private static void quitEarly(String errorMsg) {
            if (errorMsg != null) {
                String string = String.valueOf(errorMsg);
                System.err.println(string.length() != 0 ? "Error: ".concat(string) : new String("Error: "));
            }
            Css2Gss.printUsage();
            System.exit(-1);
        }

        private static boolean validateArgs(String[] args) {
            return args.length > 0 && args.length < 9;
        }

        static {
            argumentConsumers.put("-r", new ArgumentConsumer(){

                @Override
                public boolean consume(Options option, String nextArg) {
                    option.recurse = true;
                    return false;
                }
            });
            argumentConsumers.put("-condition", new ArgumentConsumer(){

                @Override
                public boolean consume(Options option, String nextArg) {
                    if (nextArg == null) {
                        Options.quitEarly("-condition option must be followed by a comma separated list of conditions");
                    }
                    option.simpleBooleanConditions = FluentIterable.from(Splitter.on(',').split(nextArg)).toSet();
                    return true;
                }
            });
            argumentConsumers.put("-basedir", new ArgumentConsumer(){

                @Override
                public boolean consume(Options option, String nextArg) {
                    String string = String.valueOf(nextArg);
                    String string2 = String.valueOf(nextArg.endsWith(File.separator) ? "" : File.separator);
                    nextArg = string2.length() != 0 ? string.concat(string2) : new String(string);
                    option.baseDir = new File(nextArg);
                    if (!option.baseDir.exists() || !option.baseDir.isDirectory()) {
                        Options.quitEarly("Basedir is does not exist");
                    }
                    return true;
                }
            });
            argumentConsumers.put("-scope", new ArgumentConsumer(){

                @Override
                public boolean consume(Options option, String nextArg) {
                    option.scope = nextArg;
                    return true;
                }
            });
        }
    }
}

