/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.http.client.Header;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.util.ArrayList;

class ResponseImpl
extends Response {
    private final XMLHttpRequest xmlHttpRequest;

    public ResponseImpl(XMLHttpRequest xmlHttpRequest) {
        this.xmlHttpRequest = xmlHttpRequest;
        assert (this.isResponseReady());
    }

    @Override
    public String getHeader(String header) {
        StringValidator.throwIfEmptyOrNull("header", header);
        return this.xmlHttpRequest.getResponseHeader(header);
    }

    @Override
    public Header[] getHeaders() {
        String allHeaders = this.getHeadersAsString();
        String[] unparsedHeaders = allHeaders.split("\n");
        ArrayList<1> parsedHeaders = new ArrayList<1>();
        for (String unparsedHeader : unparsedHeaders) {
            int endOfNameIdx;
            if (unparsedHeader == null || unparsedHeader.trim().isEmpty() || (endOfNameIdx = unparsedHeader.indexOf(58)) < 0) continue;
            final String name = unparsedHeader.substring(0, endOfNameIdx).trim();
            final String value = unparsedHeader.substring(endOfNameIdx + 1).trim();
            Header header = new Header(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getValue() {
                    return value;
                }

                public String toString() {
                    String string = name;
                    String string2 = value;
                    return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" : ").append(string2).toString();
                }
            };
            parsedHeaders.add(header);
        }
        return parsedHeaders.toArray(new Header[parsedHeaders.size()]);
    }

    @Override
    public String getHeadersAsString() {
        String headers = this.xmlHttpRequest.getAllResponseHeaders();
        return headers != null ? headers : "";
    }

    @Override
    public int getStatusCode() {
        return this.xmlHttpRequest.getStatus();
    }

    @Override
    public String getStatusText() {
        return this.xmlHttpRequest.getStatusText();
    }

    @Override
    public String getText() {
        return this.xmlHttpRequest.getResponseText();
    }

    protected boolean isResponseReady() {
        return this.xmlHttpRequest.getReadyState() == 4;
    }
}

