/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.shared;

import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.BidiUtils;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

public abstract class BidiFormatterBase {
    private boolean alwaysSpan;
    private HasDirection.Direction contextDir;

    protected BidiFormatterBase(HasDirection.Direction contextDir, boolean alwaysSpan) {
        this.contextDir = contextDir;
        this.alwaysSpan = alwaysSpan;
    }

    public HasDirection.Direction estimateDirection(String str) {
        return BidiUtils.get().estimateDirection(str);
    }

    public HasDirection.Direction estimateDirection(String str, boolean isHtml) {
        return BidiUtils.get().estimateDirection(str, isHtml);
    }

    public boolean getAlwaysSpan() {
        return this.alwaysSpan;
    }

    public HasDirection.Direction getContextDir() {
        return this.contextDir;
    }

    public boolean isRtlContext() {
        return this.contextDir == HasDirection.Direction.RTL;
    }

    protected String dirAttrBase(String str, boolean isHtml) {
        return this.knownDirAttrBase(BidiUtils.get().estimateDirection(str, isHtml));
    }

    protected String endEdgeBase() {
        return this.contextDir == HasDirection.Direction.RTL ? "left" : "right";
    }

    protected String knownDirAttrBase(HasDirection.Direction dir) {
        if (dir != this.contextDir) {
            return dir == HasDirection.Direction.LTR ? "dir=ltr" : (dir == HasDirection.Direction.RTL ? "dir=rtl" : "");
        }
        return "";
    }

    protected String markAfterBase(String str, boolean isHtml) {
        str = BidiUtils.get().stripHtmlIfNeeded(str, isHtml);
        return this.dirResetIfNeeded(str, BidiUtils.get().estimateDirection(str), false, true);
    }

    protected String markBase() {
        return this.contextDir == HasDirection.Direction.LTR ? Format.LRM_STRING : (this.contextDir == HasDirection.Direction.RTL ? Format.RLM_STRING : "");
    }

    protected String spanWrapBase(String str, boolean isHtml, boolean dirReset) {
        HasDirection.Direction dir = BidiUtils.get().estimateDirection(str, isHtml);
        return this.spanWrapWithKnownDirBase(dir, str, isHtml, dirReset);
    }

    protected String spanWrapWithKnownDirBase(HasDirection.Direction dir, String str, boolean isHtml, boolean dirReset) {
        boolean dirCondition = dir != HasDirection.Direction.DEFAULT && dir != this.contextDir;
        String origStr = str;
        if (!isHtml) {
            str = SafeHtmlUtils.htmlEscape(str);
        }
        StringBuilder result = new StringBuilder();
        if (this.alwaysSpan || dirCondition) {
            result.append("<span");
            if (dirCondition) {
                result.append(" ");
                result.append(dir == HasDirection.Direction.RTL ? "dir=rtl" : "dir=ltr");
            }
            result.append(">" + str + "</span>");
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(origStr, dir, isHtml, dirReset));
        return result.toString();
    }

    protected String startEdgeBase() {
        return this.contextDir == HasDirection.Direction.RTL ? "right" : "left";
    }

    protected String unicodeWrapBase(String str, boolean isHtml, boolean dirReset) {
        HasDirection.Direction dir = BidiUtils.get().estimateDirection(str, isHtml);
        return this.unicodeWrapWithKnownDirBase(dir, str, isHtml, dirReset);
    }

    protected String unicodeWrapWithKnownDirBase(HasDirection.Direction dir, String str, boolean isHtml, boolean dirReset) {
        StringBuilder result = new StringBuilder();
        if (dir != HasDirection.Direction.DEFAULT && dir != this.contextDir) {
            result.append(dir == HasDirection.Direction.RTL ? (char)'\u202b' : '\u202a');
            result.append(str);
            result.append('\u202c');
        } else {
            result.append(str);
        }
        result.append(this.dirResetIfNeeded(str, dir, isHtml, dirReset));
        return result.toString();
    }

    private String dirResetIfNeeded(String str, HasDirection.Direction dir, boolean isHtml, boolean dirReset) {
        if (dirReset && (this.contextDir == HasDirection.Direction.LTR && (dir == HasDirection.Direction.RTL || BidiUtils.get().endsWithRtl(str, isHtml)) || this.contextDir == HasDirection.Direction.RTL && (dir == HasDirection.Direction.LTR || BidiUtils.get().endsWithLtr(str, isHtml)))) {
            return this.contextDir == HasDirection.Direction.LTR ? Format.LRM_STRING : Format.RLM_STRING;
        }
        return "";
    }

    static final class Format {
        public static final String LEFT = "left";
        public static final char LRE = '\u202a';
        public static final char LRM = '\u200e';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final char PDF = '\u202c';
        public static final String RIGHT = "right";
        public static final char RLE = '\u202b';
        public static final char RLM = '\u200f';
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    protected static abstract class Factory<T extends BidiFormatterBase> {
        private T[] instances = new BidiFormatterBase[6];

        public abstract T createInstance(HasDirection.Direction var1, boolean var2);

        public T getInstance(HasDirection.Direction contextDir, boolean alwaysSpan) {
            int index = this.calculateIndex(contextDir, alwaysSpan);
            T formatter = this.instances[index];
            if (formatter == null) {
                this.instances[index] = formatter = this.createInstance(contextDir, alwaysSpan);
            }
            return formatter;
        }

        private int calculateIndex(HasDirection.Direction contextDir, boolean alwaysSpan) {
            int i;
            int n = contextDir == HasDirection.Direction.LTR ? 0 : (i = contextDir == HasDirection.Direction.RTL ? 1 : 2);
            if (alwaysSpan) {
                i += 3;
            }
            return i;
        }
    }
}

