/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import java.util.Date;

public class CalendarUtil {
    static DateTimeConstants intlConstants;
    private static int firstDayOfWeekend;
    private static int lastDayOfWeekend;
    private static int startingDay;

    public static void addDaysToDate(Date date, int days) {
        date.setDate(date.getDate() + days);
    }

    public static void addMonthsToDate(Date date, int months) {
        if (months != 0) {
            int month = date.getMonth();
            int year = date.getYear();
            int resultMonthCount = year * 12 + month + months;
            int resultYear = resultMonthCount / 12;
            int resultMonth = resultMonthCount - resultYear * 12;
            date.setMonth(resultMonth);
            date.setYear(resultYear);
        }
    }

    public static Date copyDate(Date date) {
        if (date == null) {
            return null;
        }
        Date newDate = new Date();
        newDate.setTime(date.getTime());
        return newDate;
    }

    public static int getDaysBetween(Date start, Date finish) {
        if (CalendarUtil.hasTime(start)) {
            start = CalendarUtil.copyDate(start);
            CalendarUtil.resetTime(start);
        }
        if (CalendarUtil.hasTime(finish)) {
            finish = CalendarUtil.copyDate(finish);
            CalendarUtil.resetTime(finish);
        }
        long aTime = start.getTime();
        long bTime = finish.getTime();
        long adjust = 3600000L;
        adjust = bTime > aTime ? adjust : -adjust;
        return (int)((bTime - aTime + adjust) / 86400000L);
    }

    public static int getStartingDayOfWeek() {
        return startingDay;
    }

    public static void setToFirstDayOfMonth(Date date) {
        CalendarUtil.resetTime(date);
        date.setDate(1);
    }

    static boolean hasTime(Date start) {
        return start.getHours() != 0 || start.getMinutes() != 0 || start.getSeconds() != 0;
    }

    static boolean isWeekend(int dayOfWeek) {
        return dayOfWeek == firstDayOfWeekend || dayOfWeek == lastDayOfWeekend;
    }

    private static void resetTime(Date date) {
        long msec = date.getTime();
        msec = msec / 1000L * 1000L;
        date.setTime(msec);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
    }

    static {
        if (GWT.isClient()) {
            intlConstants = (DateTimeConstants)GWT.create(DateTimeConstants.class);
            firstDayOfWeekend = Integer.parseInt(intlConstants.weekendRange()[0]) - 1;
            lastDayOfWeekend = Integer.parseInt(intlConstants.weekendRange()[1]) - 1;
            startingDay = Integer.parseInt(intlConstants.firstDayOfTheWeek()) - 1;
        }
    }
}

