/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.HandlesAllKeyEvents;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FiresSuggestionEvents;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesFocusEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestBox
extends Composite
implements HasText,
HasFocus,
HasAnimation,
SourcesClickEvents,
SourcesFocusEvents,
SourcesChangeEvents,
SourcesKeyboardEvents,
FiresSuggestionEvents,
HasAllKeyHandlers,
HasValue<String>,
HasSelectionHandlers<SuggestOracle.Suggestion> {
    private static final String STYLENAME_DEFAULT = "gwt-SuggestBox";
    private int limit = 20;
    private boolean selectsFirstItem = true;
    private SuggestOracle oracle;
    private String currentText;
    private final SuggestionMenu suggestionMenu;
    private final PopupPanel suggestionPopup;
    private final TextBoxBase box;
    private final SuggestOracle.Callback callback = new SuggestOracle.Callback(){

        public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
            SuggestBox.this.showSuggestions(response.getSuggestions());
        }
    };

    public static SuggestBox wrap(SuggestOracle oracle, Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        TextBox textBox = new TextBox(element);
        SuggestBox suggestBox = new SuggestBox(oracle, textBox);
        suggestBox.onAttach();
        RootPanel.detachOnWindowClose(suggestBox);
        return suggestBox;
    }

    public SuggestBox() {
        this(new MultiWordSuggestOracle());
    }

    public SuggestBox(SuggestOracle oracle) {
        this(oracle, new TextBox());
    }

    public SuggestBox(SuggestOracle oracle, TextBoxBase box) {
        this.box = box;
        this.initWidget(box);
        this.suggestionMenu = new SuggestionMenu(true);
        this.suggestionPopup = this.createPopup();
        this.suggestionPopup.setAnimationType(PopupPanel.AnimationType.ROLL_DOWN);
        this.addEventsToTextBox();
        this.setOracle(oracle);
        this.setStyleName(STYLENAME_DEFAULT);
    }

    @Override
    @Deprecated
    public void addChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedLogicalChangeListener.add(this.box, listener).setSource(this);
    }

    @Override
    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener legacy = ListenerWrapper.WrappedClickListener.add(this.box, listener);
        legacy.setSource(this);
    }

    @Override
    @Deprecated
    public void addEventHandler(SuggestionHandler handler) {
        ListenerWrapper.WrappedOldSuggestionHandler.add(this, handler);
    }

    @Override
    @Deprecated
    public void addFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener focus = ListenerWrapper.WrappedFocusListener.add(this.box, listener);
        focus.setSource(this);
    }

    @Override
    @Deprecated
    public void addKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.add(this, listener);
    }

    @Override
    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler(handler, KeyDownEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler(handler, KeyPressEvent.getType());
    }

    @Override
    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler(handler, KeyUpEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    public int getLimit() {
        return this.limit;
    }

    public SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    @Override
    public int getTabIndex() {
        return this.box.getTabIndex();
    }

    @Override
    public String getText() {
        return this.box.getText();
    }

    public TextBoxBase getTextBox() {
        return this.box;
    }

    @Override
    public String getValue() {
        return this.box.getValue();
    }

    public void hideSuggestionList() {
        this.suggestionPopup.hide();
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.suggestionPopup.isAnimationEnabled();
    }

    public boolean isAutoSelectEnabled() {
        return this.selectsFirstItem;
    }

    public boolean isSuggestionListShowing() {
        return this.suggestionPopup.isShowing();
    }

    @Override
    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this.box, listener);
    }

    @Override
    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this.box, listener);
    }

    @Override
    @Deprecated
    public void removeEventHandler(SuggestionHandler handler) {
        ListenerWrapper.WrappedOldSuggestionHandler.remove(this, handler);
    }

    @Override
    @Deprecated
    public void removeFocusListener(FocusListener listener) {
        ListenerWrapper.WrappedFocusListener.remove(this, listener);
    }

    @Override
    @Deprecated
    public void removeKeyboardListener(KeyboardListener listener) {
        ListenerWrapper.WrappedKeyboardListener.remove(this, listener);
    }

    @Override
    public void setAccessKey(char key) {
        this.box.setAccessKey(key);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.suggestionPopup.setAnimationEnabled(enable);
    }

    public void setAutoSelectEnabled(boolean selectsFirstItem) {
        this.selectsFirstItem = selectsFirstItem;
    }

    @Override
    public void setFocus(boolean focused) {
        this.box.setFocus(focused);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setPopupStyleName(String style) {
        this.suggestionPopup.setStyleName(style);
    }

    @Override
    public void setTabIndex(int index) {
        this.box.setTabIndex(index);
    }

    @Override
    public void setText(String text) {
        this.box.setText(text);
    }

    @Override
    public void setValue(String newValue) {
        this.box.setValue(newValue);
    }

    @Override
    public void setValue(String value, boolean fireEvents) {
        this.box.setValue(value, fireEvents);
    }

    public void showSuggestionList() {
        if (this.isAttached()) {
            this.currentText = null;
            this.refreshSuggestions();
        }
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.suggestionPopup.ensureDebugId(baseID + "-popup");
        this.suggestionMenu.setMenuItemDebugIds(baseID);
    }

    SuggestOracle.Suggestion getSuggestion(int index) {
        if (!this.isSuggestionListShowing()) {
            throw new IndexOutOfBoundsException("No suggestions showing, so cannot show " + index);
        }
        return ((SuggestionMenuItem)this.suggestionMenu.getItems().get(index)).suggestion;
    }

    int getSuggestionCount() {
        return this.isSuggestionListShowing() ? this.suggestionMenu.getNumItems() : 0;
    }

    void showSuggestions(String query) {
        if (query.length() == 0) {
            this.oracle.requestDefaultSuggestions(new SuggestOracle.Request(null, this.limit), this.callback);
        } else {
            this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.limit), this.callback);
        }
    }

    private void addEventsToTextBox() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TextBoxEvents
        extends HandlesAllKeyEvents
        implements ValueChangeHandler<String> {
            TextBoxEvents() {
            }

            @Override
            public void onKeyDown(KeyDownEvent event) {
                if (SuggestBox.this.suggestionPopup.isAttached()) {
                    switch (event.getNativeKeyCode()) {
                        case 40: {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() + 1);
                            break;
                        }
                        case 38: {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() - 1);
                            break;
                        }
                        case 9: 
                        case 13: {
                            if (SuggestBox.this.suggestionMenu.getSelectedItemIndex() < 0) {
                                SuggestBox.this.suggestionPopup.hide();
                                break;
                            }
                            SuggestBox.this.suggestionMenu.doSelectedItemAction();
                        }
                    }
                }
                SuggestBox.this.delegateEvent(SuggestBox.this, event);
            }

            @Override
            public void onKeyPress(KeyPressEvent event) {
                SuggestBox.this.delegateEvent(SuggestBox.this, event);
            }

            @Override
            public void onKeyUp(KeyUpEvent event) {
                SuggestBox.this.refreshSuggestions();
                SuggestBox.this.delegateEvent(SuggestBox.this, event);
            }

            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                SuggestBox.this.delegateEvent(SuggestBox.this, event);
            }
        }
        TextBoxEvents events = new TextBoxEvents();
        events.addKeyHandlersTo(this.box);
        this.box.addValueChangeHandler(events);
    }

    private PopupPanel createPopup() {
        DecoratedPopupPanel p = new DecoratedPopupPanel(true, false, "suggestPopup");
        ((PopupPanel)p).setWidget(this.suggestionMenu);
        p.setStyleName("gwt-SuggestBoxPopup");
        p.setPreviewingAllNativeEvents(true);
        p.addAutoHidePartner(this.getTextBox().getElement());
        return p;
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        SelectionEvent.fire(this, selectedSuggestion);
    }

    private void refreshSuggestions() {
        String text = this.box.getText();
        if (text.equals(this.currentText)) {
            return;
        }
        this.currentText = text;
        this.showSuggestions(text);
    }

    private void setNewSelection(SuggestionMenuItem menuItem) {
        SuggestOracle.Suggestion curSuggestion = menuItem.getSuggestion();
        this.currentText = curSuggestion.getReplacementString();
        this.setText(this.currentText);
        this.suggestionPopup.hide();
        this.fireSuggestionEvent(curSuggestion);
    }

    private void setOracle(SuggestOracle oracle) {
        this.oracle = oracle;
    }

    private void showSuggestions(Collection<? extends SuggestOracle.Suggestion> suggestions) {
        if (suggestions.size() > 0) {
            boolean isAnimationEnabled = this.suggestionPopup.isAnimationEnabled();
            if (this.suggestionPopup.isAttached()) {
                this.suggestionPopup.hide();
            }
            this.suggestionMenu.clearItems();
            for (SuggestOracle.Suggestion suggestion : suggestions) {
                final SuggestionMenuItem menuItem = new SuggestionMenuItem(suggestion, this.oracle.isDisplayStringHTML());
                menuItem.setCommand(new Command(){

                    public void execute() {
                        SuggestBox.this.setNewSelection(menuItem);
                    }
                });
                this.suggestionMenu.addItem(menuItem);
            }
            if (this.selectsFirstItem) {
                this.suggestionMenu.selectItem(0);
            }
            this.suggestionPopup.showRelativeTo(this.getTextBox());
            this.suggestionPopup.setAnimationEnabled(isAnimationEnabled);
        } else {
            this.suggestionPopup.hide();
        }
    }

    private static class SuggestionMenuItem
    extends MenuItem {
        private static final String STYLENAME_DEFAULT = "item";
        private SuggestOracle.Suggestion suggestion;

        public SuggestionMenuItem(SuggestOracle.Suggestion suggestion, boolean asHTML) {
            super(suggestion.getDisplayString(), asHTML);
            DOM.setStyleAttribute(this.getElement(), "whiteSpace", "nowrap");
            this.setStyleName(STYLENAME_DEFAULT);
            this.setSuggestion(suggestion);
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(SuggestOracle.Suggestion suggestion) {
            this.suggestion = suggestion;
        }
    }

    private static class SuggestionMenu
    extends MenuBar {
        public SuggestionMenu(boolean vertical) {
            super(vertical);
            this.setStyleName("");
        }

        public void doSelectedItemAction() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                this.doItemAction(selectedItem, true);
            }
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List<MenuItem> items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.itemOver(items.get(index), false);
            }
        }
    }
}

