/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.common.base.Preconditions;
import java.io.Closeable;

public class ProgressEventDispatcher
implements Closeable {
    private final EventHandlers eventHandlers;
    private final Allocation allocation;
    private long remainingAllocationUnits;
    private boolean closed = false;

    public static ProgressEventDispatcher newRoot(EventHandlers eventHandlers, String description, long allocationUnits) {
        return ProgressEventDispatcher.newProgressEventDispatcher(eventHandlers, Allocation.newRoot(description, allocationUnits));
    }

    private static ProgressEventDispatcher newProgressEventDispatcher(EventHandlers eventHandlers, Allocation allocation) {
        ProgressEventDispatcher progressEventDispatcher = new ProgressEventDispatcher(eventHandlers, allocation);
        progressEventDispatcher.dispatchProgress(0L);
        return progressEventDispatcher;
    }

    private ProgressEventDispatcher(EventHandlers eventHandlers, Allocation allocation) {
        this.eventHandlers = eventHandlers;
        this.allocation = allocation;
        this.remainingAllocationUnits = allocation.getAllocationUnits();
    }

    public Factory newChildProducer() {
        this.decrementRemainingAllocationUnits(1L);
        return new Factory(){
            private boolean used = false;

            @Override
            public ProgressEventDispatcher create(String description, long allocationUnits) {
                Preconditions.checkState((!this.used ? 1 : 0) != 0);
                this.used = true;
                return ProgressEventDispatcher.newProgressEventDispatcher(ProgressEventDispatcher.this.eventHandlers, ProgressEventDispatcher.this.allocation.newChild(description, allocationUnits));
            }
        };
    }

    @Override
    public void close() {
        if (this.remainingAllocationUnits > 0L) {
            this.dispatchProgress(this.remainingAllocationUnits);
        }
        this.closed = true;
    }

    public void dispatchProgress(long progressUnits) {
        long unitsDecremented = this.decrementRemainingAllocationUnits(progressUnits);
        this.eventHandlers.dispatch(new ProgressEvent(this.allocation, unitsDecremented));
    }

    private long decrementRemainingAllocationUnits(long units) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.remainingAllocationUnits >= units) {
            this.remainingAllocationUnits -= units;
            return units;
        }
        long actualDecrement = this.remainingAllocationUnits;
        this.remainingAllocationUnits = 0L;
        return actualDecrement;
    }

    @FunctionalInterface
    public static interface Factory {
        public ProgressEventDispatcher create(String var1, long var2);
    }
}

