/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parametermanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterManagerSettings;
import com.google.cloud.spring.autoconfigure.parametermanager.ParameterManagerConfigDataLoader;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.parametermanager.ParameterManagerClientFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DefaultParameterManagerClientFactory
implements ParameterManagerClientFactory {
    private final CredentialsProvider credentialsProvider;
    private final Map<String, ParameterManagerClient> clientCache = new ConcurrentHashMap<String, ParameterManagerClient>();

    DefaultParameterManagerClientFactory(CredentialsProvider credentialsProvider, ParameterManagerClient client) {
        this.credentialsProvider = credentialsProvider;
        this.clientCache.putIfAbsent("global", client);
    }

    public ParameterManagerClient getClient(@Nullable String location) {
        if (ObjectUtils.isEmpty((Object)location)) {
            location = "global";
        }
        return this.clientCache.computeIfAbsent(location, loc -> {
            try {
                ParameterManagerSettings.Builder settings = (ParameterManagerSettings.Builder)((ParameterManagerSettings.Builder)ParameterManagerSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(ParameterManagerConfigDataLoader.class));
                if (!loc.equals("global")) {
                    settings.setEndpoint(String.format("parametermanager.%s.rep.googleapis.com:443", loc));
                }
                return ParameterManagerClient.create((ParameterManagerSettings)settings.build());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create ParameterManagerClient for location: " + loc, e);
            }
        });
    }
}

