/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache.dev;

import com.google.appengine.api.memcache.MemcacheSerialization;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.dev.LRU;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalMemcacheService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "memcache";
    public static final String SIZE_PROPERTY = "memcache.maxsize";
    private static final String DEFAULT_MAX_SIZE = "100M";
    private static final String UTF8 = "UTF-8";
    private static final BigInteger UINT64_MIN_VALUE = BigInteger.ZERO;
    private static final BigInteger UINT64_MAX_VALUE = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private final AtomicLong globalNextCasId;
    private LRU<CacheEntry> lru = new LRU();
    private final Map<String, Map<Key, CacheEntry>> mockCache = new HashMap<String, Map<Key, CacheEntry>>();
    private final Map<String, Map<Key, Long>> deleteHold = new HashMap<String, Map<Key, Long>>();
    private long maxSize;
    private LocalStats stats = new LocalStats(0L, 0L, 0L, 0L, 0L);
    private Clock clock;

    public LocalMemcacheService() {
        this.globalNextCasId = new AtomicLong(1L);
    }

    private <K1, K2, V> Map<K2, V> getOrMakeSubMap(Map<K1, Map<K2, V>> map, K1 key) {
        Map<K2, V> subMap = map.get(key);
        if (subMap == null) {
            subMap = new HashMap<K2, V>();
            map.put(key, subMap);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getWithExpiration(String namespace, Key key) {
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            CacheEntry entry = this.getOrMakeSubMap(this.mockCache, namespace).get(key);
            if (entry != null) {
                if (entry.expires == 0L || this.clock.getCurrentTime() < entry.expires) {
                    entry.access = this.clock.getCurrentTime();
                    this.lru.update(entry);
                    return entry;
                }
                this.getOrMakeSubMap(this.mockCache, namespace).remove(key);
                this.lru.remove(entry);
                this.stats.recordDelete(entry);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry internalDelete(String namespace, Key key) {
        CacheEntry ce;
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            ce = this.getOrMakeSubMap(this.mockCache, namespace).remove(key);
            if (ce != null) {
                this.lru.remove(ce);
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSet(String namespace, Key key, CacheEntry entry) {
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            Map<Key, CacheEntry> namespaceMap = this.getOrMakeSubMap(this.mockCache, namespace);
            CacheEntry old = namespaceMap.get(key);
            if (old != null) {
                this.lru.remove(old);
                this.stats.recordDelete(old);
            }
            namespaceMap.put(key, entry);
            this.lru.update(entry);
            this.stats.recordAdd(entry);
        }
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.clock = context.getClock();
        String propValue = properties.get(SIZE_PROPERTY);
        propValue = propValue == null ? DEFAULT_MAX_SIZE : propValue.toUpperCase();
        int multiplier = 1;
        if (propValue.endsWith("M") || propValue.endsWith("K")) {
            multiplier = propValue.endsWith("M") ? 0x100000 : 1024;
            propValue = propValue.substring(0, propValue.length() - 1);
        }
        try {
            this.maxSize = Long.parseLong(propValue) * (long)multiplier;
        }
        catch (NumberFormatException ex) {
            throw new MemcacheServiceException("Can't parse cache size limit '" + properties.get(SIZE_PROPERTY) + "'", (Throwable)ex);
        }
    }

    public void setLimits(int bytes) {
        this.maxSize = bytes;
    }

    public void start() {
    }

    public void stop() {
    }

    public MemcacheServicePb.MemcacheGetResponse get(LocalRpcService.Status status, MemcacheServicePb.MemcacheGetRequest req) {
        MemcacheServicePb.MemcacheGetResponse.Builder result = MemcacheServicePb.MemcacheGetResponse.newBuilder();
        for (int i = 0; i < req.getKeyCount(); ++i) {
            Key key = new Key(req.getKey(i).toByteArray());
            CacheEntry entry = this.getWithExpiration(req.getNameSpace(), key);
            if (entry == null) {
                this.stats.recordMiss();
                continue;
            }
            this.stats.recordHit(entry);
            MemcacheServicePb.MemcacheGetResponse.Item.Builder item = MemcacheServicePb.MemcacheGetResponse.Item.newBuilder();
            item.setKey(ByteString.copyFrom((byte[])key.getBytes())).setFlags(entry.flags).setValue(ByteString.copyFrom((byte[])entry.value));
            if (req.hasForCas() && req.getForCas()) {
                entry.markWithCasId();
                item.setCasId(entry.getCasId());
            }
            result.addItem(item.build());
        }
        status.setSuccessful(true);
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheGrabTailResponse grabTail(LocalRpcService.Status status, MemcacheServicePb.MemcacheGrabTailRequest req) {
        MemcacheServicePb.MemcacheGrabTailResponse.Builder result = MemcacheServicePb.MemcacheGrabTailResponse.newBuilder();
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            Map<Key, CacheEntry> map2 = this.getOrMakeSubMap(this.mockCache, req.getNameSpace());
            List entries = Ordering.natural().sortedCopy(map2.values());
            int itemCount = 0;
            for (CacheEntry entry : entries) {
                this.internalDelete(req.getNameSpace(), entry.key);
                this.stats.recordHit(entry);
                result.addItem(MemcacheServicePb.MemcacheGrabTailResponse.Item.newBuilder().setFlags(entry.flags).setValue(ByteString.copyFrom((byte[])entry.value)).build());
                if (++itemCount != req.getItemCount()) continue;
                break;
            }
        }
        status.setSuccessful(true);
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheSetResponse set(LocalRpcService.Status status, MemcacheServicePb.MemcacheSetRequest req) {
        MemcacheServicePb.MemcacheSetResponse.Builder result = MemcacheServicePb.MemcacheSetResponse.newBuilder();
        String namespace = req.getNameSpace();
        for (int i = 0; i < req.getItemCount(); ++i) {
            MemcacheServicePb.MemcacheSetRequest.Item item = req.getItem(i);
            Key key = new Key(item.getKey().toByteArray());
            MemcacheServicePb.MemcacheSetRequest.SetPolicy policy = item.getSetPolicy();
            Map<Key, Long> timeoutMap = this.getOrMakeSubMap(this.deleteHold, namespace);
            Long timeout = timeoutMap.get(key);
            if (timeout != null && policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET) {
                timeout = null;
                timeoutMap.remove(key);
            }
            if (timeout != null && this.clock.getCurrentTime() < timeout || policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS && !item.hasCasId()) {
                result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.NOT_STORED);
                continue;
            }
            Map<String, Map<Key, CacheEntry>> map = this.mockCache;
            synchronized (map) {
                CacheEntry existingEntry = this.getWithExpiration(namespace, key);
                if (policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.REPLACE && existingEntry == null || policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.ADD && existingEntry != null || policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS && existingEntry == null) {
                    result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.NOT_STORED);
                } else if (!(policy != MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS || existingEntry.hasCasId() && existingEntry.getCasId() == item.getCasId())) {
                    result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.EXISTS);
                } else {
                    long expiry = item.hasExpirationTime() ? (long)item.getExpirationTime() : 0L;
                    byte[] value = item.getValue().toByteArray();
                    int flags = item.getFlags();
                    CacheEntry newEntry = new CacheEntry(namespace, key, value, flags, expiry * 1000L);
                    this.internalSet(namespace, key, newEntry);
                    result.addSetStatus(MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED);
                }
                continue;
            }
        }
        status.setSuccessful(true);
        return result.build();
    }

    @LatencyPercentiles(latency50th=4)
    public MemcacheServicePb.MemcacheDeleteResponse delete(LocalRpcService.Status status, MemcacheServicePb.MemcacheDeleteRequest req) {
        MemcacheServicePb.MemcacheDeleteResponse.Builder result = MemcacheServicePb.MemcacheDeleteResponse.newBuilder();
        String namespace = req.getNameSpace();
        for (int i = 0; i < req.getItemCount(); ++i) {
            MemcacheServicePb.MemcacheDeleteRequest.Item item = req.getItem(i);
            Key key = new Key(item.getKey().toByteArray());
            CacheEntry ce = this.internalDelete(namespace, key);
            result.addDeleteStatus(ce == null ? MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.NOT_FOUND : MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED);
            if (ce != null) {
                this.stats.recordDelete(ce);
            }
            if (!item.hasDeleteTime()) continue;
            int millisNoReAdd = item.getDeleteTime() * 1000;
            this.getOrMakeSubMap(this.deleteHold, namespace).put(key, this.clock.getCurrentTime() + (long)millisNoReAdd);
        }
        status.setSuccessful(true);
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheIncrementResponse increment(LocalRpcService.Status status, MemcacheServicePb.MemcacheIncrementRequest req) {
        MemcacheServicePb.MemcacheIncrementResponse.Builder result = MemcacheServicePb.MemcacheIncrementResponse.newBuilder();
        String namespace = req.getNameSpace();
        Key key = new Key(req.getKey().toByteArray());
        long delta = req.getDirection() == MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT ? -req.getDelta() : req.getDelta();
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            BigInteger value;
            CacheEntry ce = this.getWithExpiration(namespace, key);
            if (ce == null) {
                if (req.hasInitialValue()) {
                    value = BigInteger.valueOf(req.getInitialValue()).and(UINT64_MAX_VALUE);
                    int flags = req.hasInitialFlags() ? req.getInitialFlags() : MemcacheSerialization.Flag.LONG.ordinal();
                    ce = new CacheEntry(namespace, key, value.toString().getBytes(), flags, 0L);
                    this.internalSet(namespace, key, ce);
                } else {
                    this.stats.recordMiss();
                    return result.build();
                }
            }
            this.stats.recordHit(ce);
            try {
                value = new BigInteger(new String(ce.value, UTF8));
            }
            catch (NumberFormatException e) {
                status.setSuccessful(false);
                throw new ApiProxy.ApplicationException(6, "Format error");
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiProxy.UnknownException("UTF-8 encoding was not found.");
            }
            if (value.compareTo(UINT64_MAX_VALUE) > 0 || value.signum() < 0) {
                status.setSuccessful(false);
                throw new ApiProxy.ApplicationException(6, "Value to be incremented must be in the range of an unsigned 64-bit number");
            }
            if ((value = value.add(BigInteger.valueOf(delta))).signum() < 0) {
                value = UINT64_MIN_VALUE;
            } else if (value.compareTo(UINT64_MAX_VALUE) > 0) {
                value = value.and(UINT64_MAX_VALUE);
            }
            this.stats.recordDelete(ce);
            try {
                ce.value = value.toString().getBytes(UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiProxy.UnknownException("UTF-8 encoding was not found.");
            }
            ce.bytes = key.getBytes().length + ce.value.length;
            Map<Key, CacheEntry> namespaceMap = this.getOrMakeSubMap(this.mockCache, namespace);
            namespaceMap.remove(key);
            namespaceMap.put(key, ce);
            this.stats.recordAdd(ce);
            result.setNewValue(value.longValue());
        }
        status.setSuccessful(true);
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheBatchIncrementResponse batchIncrement(LocalRpcService.Status status, MemcacheServicePb.MemcacheBatchIncrementRequest batchReq) {
        MemcacheServicePb.MemcacheBatchIncrementResponse.Builder result = MemcacheServicePb.MemcacheBatchIncrementResponse.newBuilder();
        String namespace = batchReq.getNameSpace();
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            for (MemcacheServicePb.MemcacheIncrementRequest req : batchReq.getItemList()) {
                Long longval;
                CacheEntry ce;
                MemcacheServicePb.MemcacheIncrementResponse.Builder resp = MemcacheServicePb.MemcacheIncrementResponse.newBuilder();
                Key key = new Key(req.getKey().toByteArray());
                long delta = req.getDelta();
                if (req.getDirection() == MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT) {
                    delta = -delta;
                }
                if ((ce = this.getWithExpiration(namespace, key)) == null) {
                    if (req.hasInitialValue()) {
                        MemcacheSerialization.ValueAndFlags value;
                        try {
                            value = MemcacheSerialization.serialize((Object)req.getInitialValue());
                        }
                        catch (IOException e) {
                            throw new ApiProxy.UnknownException("Serialzation error: " + e);
                        }
                        ce = new CacheEntry(namespace, key, value.value, value.flags.ordinal(), 0L);
                    } else {
                        this.stats.recordMiss();
                        resp.setIncrementStatus(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.NOT_CHANGED);
                        result.addItem(resp);
                        continue;
                    }
                }
                this.stats.recordHit(ce);
                try {
                    longval = Long.parseLong(new String(ce.value, UTF8));
                }
                catch (NumberFormatException e) {
                    resp.setIncrementStatus(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.NOT_CHANGED);
                    result.addItem(resp);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    resp.setIncrementStatus(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.NOT_CHANGED);
                    result.addItem(resp);
                    continue;
                }
                if (longval < 0L) {
                    resp.setIncrementStatus(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.NOT_CHANGED);
                    result.addItem(resp);
                    continue;
                }
                long newvalue = longval;
                if (delta < 0L && (newvalue += delta) < 0L) {
                    newvalue = 0L;
                }
                this.stats.recordDelete(ce);
                try {
                    ce.value = Long.toString(newvalue).getBytes(UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ApiProxy.UnknownException("UTF-8 encoding was not found.");
                }
                ce.bytes = key.getBytes().length + ce.value.length;
                Map<Key, CacheEntry> namespaceMap = this.getOrMakeSubMap(this.mockCache, namespace);
                namespaceMap.remove(key);
                namespaceMap.put(key, ce);
                this.stats.recordAdd(ce);
                resp.setIncrementStatus(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.OK);
                resp.setNewValue(newvalue);
                result.addItem(resp);
            }
        }
        status.setSuccessful(true);
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcacheServicePb.MemcacheFlushResponse flushAll(LocalRpcService.Status status, MemcacheServicePb.MemcacheFlushRequest req) {
        MemcacheServicePb.MemcacheFlushResponse.Builder result = MemcacheServicePb.MemcacheFlushResponse.newBuilder();
        Map<String, Map<Key, CacheEntry>> map = this.mockCache;
        synchronized (map) {
            this.mockCache.clear();
            this.deleteHold.clear();
            this.lru.clear();
            this.stats = new LocalStats(0L, 0L, 0L, 0L, 0L);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public MemcacheServicePb.MemcacheStatsResponse stats(LocalRpcService.Status status, MemcacheServicePb.MemcacheStatsRequest req) {
        MemcacheServicePb.MemcacheStatsResponse result = MemcacheServicePb.MemcacheStatsResponse.newBuilder().setStats(this.stats.getAsMergedNamespaceStats()).build();
        status.setSuccessful(true);
        return result;
    }

    public long getMaxSizeInBytes() {
        return this.maxSize;
    }

    public Integer getMaxApiRequestSize() {
        return 0x2000000;
    }

    LRU getLRU() {
        return this.lru;
    }

    private class Key {
        private byte[] keyval;

        public Key(byte[] bytes) {
            this.keyval = bytes;
        }

        public byte[] getBytes() {
            return this.keyval;
        }

        public boolean equals(Object other) {
            if (other instanceof Key) {
                return Arrays.equals(this.keyval, ((Key)other).keyval);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.keyval);
        }
    }

    private class LocalStats {
        private long hits;
        private long misses;
        private long hitBytes;
        private long itemCount;
        private long totalBytes;

        private LocalStats(long hits, long misses, long hitBytes, long itemCount, long totalBytes) {
            this.hits = hits;
            this.misses = misses;
            this.hitBytes = hitBytes;
            this.itemCount = itemCount;
            this.totalBytes = totalBytes;
        }

        public MemcacheServicePb.MergedNamespaceStats getAsMergedNamespaceStats() {
            return MemcacheServicePb.MergedNamespaceStats.newBuilder().setHits(this.hits).setMisses(this.misses).setByteHits(this.hitBytes).setBytes(this.totalBytes).setItems(this.itemCount).setOldestItemAge(this.getMaxSecondsWithoutAccess()).build();
        }

        public int getMaxSecondsWithoutAccess() {
            if (LocalMemcacheService.this.lru.isEmpty()) {
                return 0;
            }
            CacheEntry entry = (CacheEntry)LocalMemcacheService.this.lru.getOldest();
            return (int)((LocalMemcacheService.this.clock.getCurrentTime() - entry.access) / 1000L);
        }

        public void recordHit(CacheEntry ce) {
            ++this.hits;
            this.hitBytes += ce.bytes;
        }

        public void recordMiss() {
            ++this.misses;
        }

        public void recordAdd(CacheEntry ce) {
            ++this.itemCount;
            this.totalBytes += ce.bytes;
            while (this.totalBytes > LocalMemcacheService.this.maxSize) {
                CacheEntry oldest = (CacheEntry)LocalMemcacheService.this.lru.getOldest();
                LocalMemcacheService.this.internalDelete(oldest.namespace, oldest.key);
                --this.itemCount;
                this.totalBytes -= oldest.bytes;
            }
        }

        public void recordDelete(CacheEntry ce) {
            --this.itemCount;
            this.totalBytes -= ce.bytes;
        }
    }

    private class CacheEntry
    extends LRU.AbstractChainable<CacheEntry>
    implements Comparable<CacheEntry> {
        public final String namespace;
        public final Key key;
        public byte[] value;
        int flags;
        public long expires;
        public long access;
        public long bytes;
        public Long casId;

        public CacheEntry(String namespace, Key key, byte[] value, int flags, long expiration) {
            this.namespace = namespace;
            this.key = key;
            this.value = value;
            this.flags = flags;
            this.expires = expiration;
            this.access = LocalMemcacheService.this.clock.getCurrentTime();
            this.bytes = key.getBytes().length + value.length;
            this.casId = null;
        }

        @Override
        public int compareTo(CacheEntry entry) {
            return Long.compare(this.access, entry.access);
        }

        void markWithCasId() {
            if (this.hasCasId()) {
                return;
            }
            this.casId = new Long(LocalMemcacheService.this.globalNextCasId.addAndGet(1L) - 1L);
        }

        long getCasId() {
            return this.casId;
        }

        boolean hasCasId() {
            return this.casId != null;
        }
    }
}

