/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.DocInverterPerThread;
import com.google.appengine.repackaged.org.apache.lucene.index.DocumentsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfos;
import com.google.appengine.repackaged.org.apache.lucene.index.InvertedDocConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.InvertedDocConsumerPerThread;
import com.google.appengine.repackaged.org.apache.lucene.index.RawPostingList;
import com.google.appengine.repackaged.org.apache.lucene.index.SegmentWriteState;
import com.google.appengine.repackaged.org.apache.lucene.index.TermsHashConsumer;
import com.google.appengine.repackaged.org.apache.lucene.index.TermsHashConsumerPerField;
import com.google.appengine.repackaged.org.apache.lucene.index.TermsHashPerField;
import com.google.appengine.repackaged.org.apache.lucene.index.TermsHashPerThread;
import com.google.appengine.repackaged.org.apache.lucene.util.ArrayUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class TermsHash
extends InvertedDocConsumer {
    final TermsHashConsumer consumer;
    final TermsHash nextTermsHash;
    final int bytesPerPosting;
    final int postingsFreeChunk;
    final DocumentsWriter docWriter;
    private RawPostingList[] postingsFreeList = new RawPostingList[1];
    private int postingsFreeCount;
    private int postingsAllocCount;
    boolean trackAllocations;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TermsHash(DocumentsWriter docWriter, boolean trackAllocations, TermsHashConsumer consumer, TermsHash nextTermsHash) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        this.nextTermsHash = nextTermsHash;
        this.trackAllocations = trackAllocations;
        this.bytesPerPosting = consumer.bytesPerPosting() + 4 * DocumentsWriter.POINTER_NUM_BYTE;
        this.postingsFreeChunk = 32768 / this.bytesPerPosting;
    }

    InvertedDocConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, null);
    }

    TermsHashPerThread addThread(DocInverterPerThread docInverterPerThread, TermsHashPerThread primaryPerThread) {
        return new TermsHashPerThread(docInverterPerThread, this, this.nextTermsHash, primaryPerThread);
    }

    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
        this.consumer.setFieldInfos(fieldInfos);
    }

    public void abort() {
        this.consumer.abort();
        if (this.nextTermsHash != null) {
            this.nextTermsHash.abort();
        }
    }

    void shrinkFreePostings(Map threadsAndFields, SegmentWriteState state) {
        if (!$assertionsDisabled && this.postingsFreeCount != this.postingsAllocCount) {
            throw new AssertionError((Object)(Thread.currentThread().getName() + ": postingsFreeCount=" + this.postingsFreeCount + " postingsAllocCount=" + this.postingsAllocCount + " consumer=" + this.consumer));
        }
        boolean newSize = true;
        if (1 != this.postingsFreeList.length) {
            if (this.postingsFreeCount > 1) {
                if (this.trackAllocations) {
                    this.docWriter.bytesAllocated(-(this.postingsFreeCount - 1) * this.bytesPerPosting);
                }
                this.postingsFreeCount = 1;
                this.postingsAllocCount = 1;
            }
            RawPostingList[] newArray = new RawPostingList[1];
            System.arraycopy(this.postingsFreeList, 0, newArray, 0, this.postingsFreeCount);
            this.postingsFreeList = newArray;
        }
    }

    synchronized void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.closeDocStore(state);
        }
    }

    synchronized void flush(Map threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap childThreadsAndFields = new HashMap();
        HashMap nextThreadsAndFields = this.nextTermsHash != null ? new HashMap() : null;
        Iterator it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            TermsHashPerThread perThread = (TermsHashPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<TermsHashConsumerPerField> childFields = new HashSet<TermsHashConsumerPerField>();
            HashSet<TermsHashPerField> nextChildFields = this.nextTermsHash != null ? new HashSet<TermsHashPerField>() : null;
            while (fieldsIt.hasNext()) {
                TermsHashPerField perField = (TermsHashPerField)fieldsIt.next();
                childFields.add(perField.consumer);
                if (this.nextTermsHash == null) continue;
                nextChildFields.add(perField.nextPerField);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            if (this.nextTermsHash == null) continue;
            nextThreadsAndFields.put(perThread.nextPerThread, nextChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.shrinkFreePostings(threadsAndFields, state);
        if (this.nextTermsHash != null) {
            this.nextTermsHash.flush(nextThreadsAndFields, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeRAM() {
        boolean any;
        if (!this.trackAllocations) {
            return false;
        }
        long bytesFreed = 0L;
        TermsHash termsHash = this;
        synchronized (termsHash) {
            int numToFree = this.postingsFreeCount >= this.postingsFreeChunk ? this.postingsFreeChunk : this.postingsFreeCount;
            boolean bl = any = numToFree > 0;
            if (any) {
                Arrays.fill(this.postingsFreeList, this.postingsFreeCount - numToFree, this.postingsFreeCount, null);
                this.postingsFreeCount -= numToFree;
                this.postingsAllocCount -= numToFree;
                bytesFreed = -numToFree * this.bytesPerPosting;
                any = true;
            }
        }
        if (any) {
            this.docWriter.bytesAllocated(bytesFreed);
        }
        if (this.nextTermsHash != null) {
            any |= this.nextTermsHash.freeRAM();
        }
        return any;
    }

    public synchronized void recyclePostings(RawPostingList[] postings, int numPostings) {
        if (!$assertionsDisabled && postings.length < numPostings) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.postingsFreeCount + numPostings > this.postingsFreeList.length) {
            throw new AssertionError();
        }
        System.arraycopy(postings, 0, this.postingsFreeList, this.postingsFreeCount, numPostings);
        this.postingsFreeCount += numPostings;
    }

    public synchronized void getPostings(RawPostingList[] postings) {
        if (!$assertionsDisabled && !this.docWriter.writer.testPoint("TermsHash.getPostings start")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.postingsFreeCount > this.postingsFreeList.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.postingsFreeCount > this.postingsAllocCount) {
            throw new AssertionError((Object)("postingsFreeCount=" + this.postingsFreeCount + " postingsAllocCount=" + this.postingsAllocCount));
        }
        int numToCopy = this.postingsFreeCount < postings.length ? this.postingsFreeCount : postings.length;
        int start = this.postingsFreeCount - numToCopy;
        if (!$assertionsDisabled && start < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && start + numToCopy > this.postingsFreeList.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && numToCopy > postings.length) {
            throw new AssertionError();
        }
        System.arraycopy(this.postingsFreeList, start, postings, 0, numToCopy);
        if (numToCopy != postings.length) {
            int extra = postings.length - numToCopy;
            int newPostingsAllocCount = this.postingsAllocCount + extra;
            this.consumer.createPostings(postings, numToCopy, extra);
            if (!$assertionsDisabled && !this.docWriter.writer.testPoint("TermsHash.getPostings after create")) {
                throw new AssertionError();
            }
            this.postingsAllocCount += extra;
            if (this.trackAllocations) {
                this.docWriter.bytesAllocated(extra * this.bytesPerPosting);
            }
            if (newPostingsAllocCount > this.postingsFreeList.length) {
                this.postingsFreeList = new RawPostingList[ArrayUtil.getNextSize(newPostingsAllocCount)];
            }
        }
        this.postingsFreeCount -= numToCopy;
        if (this.trackAllocations) {
            this.docWriter.bytesUsed(postings.length * this.bytesPerPosting);
        }
    }

    static {
        $assertionsDisabled = !TermsHash.class.desiredAssertionStatus();
    }
}

