/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.client;

import com.google.appengine.repackaged.org.apache.http.ConnectionReuseStrategy;
import com.google.appengine.repackaged.org.apache.http.HttpVersion;
import com.google.appengine.repackaged.org.apache.http.annotation.ThreadSafe;
import com.google.appengine.repackaged.org.apache.http.auth.AuthSchemeRegistry;
import com.google.appengine.repackaged.org.apache.http.client.AuthenticationHandler;
import com.google.appengine.repackaged.org.apache.http.client.CookieStore;
import com.google.appengine.repackaged.org.apache.http.client.CredentialsProvider;
import com.google.appengine.repackaged.org.apache.http.client.HttpRequestRetryHandler;
import com.google.appengine.repackaged.org.apache.http.client.RedirectHandler;
import com.google.appengine.repackaged.org.apache.http.client.UserTokenHandler;
import com.google.appengine.repackaged.org.apache.http.client.protocol.RequestAddCookies;
import com.google.appengine.repackaged.org.apache.http.client.protocol.RequestClientConnControl;
import com.google.appengine.repackaged.org.apache.http.client.protocol.RequestDefaultHeaders;
import com.google.appengine.repackaged.org.apache.http.client.protocol.RequestProxyAuthentication;
import com.google.appengine.repackaged.org.apache.http.client.protocol.RequestTargetAuthentication;
import com.google.appengine.repackaged.org.apache.http.client.protocol.ResponseProcessCookies;
import com.google.appengine.repackaged.org.apache.http.conn.ClientConnectionManager;
import com.google.appengine.repackaged.org.apache.http.conn.ClientConnectionManagerFactory;
import com.google.appengine.repackaged.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.google.appengine.repackaged.org.apache.http.conn.routing.HttpRoutePlanner;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.PlainSocketFactory;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.Scheme;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.SchemeRegistry;
import com.google.appengine.repackaged.org.apache.http.conn.ssl.SSLSocketFactory;
import com.google.appengine.repackaged.org.apache.http.cookie.CookieSpecRegistry;
import com.google.appengine.repackaged.org.apache.http.impl.DefaultConnectionReuseStrategy;
import com.google.appengine.repackaged.org.apache.http.impl.auth.BasicSchemeFactory;
import com.google.appengine.repackaged.org.apache.http.impl.auth.DigestSchemeFactory;
import com.google.appengine.repackaged.org.apache.http.impl.client.AbstractHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.client.BasicCookieStore;
import com.google.appengine.repackaged.org.apache.http.impl.client.BasicCredentialsProvider;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultProxyAuthenticationHandler;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultRedirectHandler;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultTargetAuthenticationHandler;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultUserTokenHandler;
import com.google.appengine.repackaged.org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import com.google.appengine.repackaged.org.apache.http.impl.conn.SingleClientConnManager;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.BestMatchSpecFactory;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.RFC2109SpecFactory;
import com.google.appengine.repackaged.org.apache.http.impl.cookie.RFC2965SpecFactory;
import com.google.appengine.repackaged.org.apache.http.params.BasicHttpParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpProtocolParams;
import com.google.appengine.repackaged.org.apache.http.protocol.BasicHttpContext;
import com.google.appengine.repackaged.org.apache.http.protocol.BasicHttpProcessor;
import com.google.appengine.repackaged.org.apache.http.protocol.HttpContext;
import com.google.appengine.repackaged.org.apache.http.protocol.HttpRequestExecutor;
import com.google.appengine.repackaged.org.apache.http.protocol.RequestContent;
import com.google.appengine.repackaged.org.apache.http.protocol.RequestExpectContinue;
import com.google.appengine.repackaged.org.apache.http.protocol.RequestTargetHost;
import com.google.appengine.repackaged.org.apache.http.protocol.RequestUserAgent;
import com.google.appengine.repackaged.org.apache.http.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public DefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, "ISO-8859-1");
        HttpProtocolParams.setUseExpectContinue(params, true);
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("com.google.appengine.repackaged.org.apache.http.client", this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
        return params;
    }

    protected HttpRequestExecutor createRequestExecutor() {
        return new HttpRequestExecutor();
    }

    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
        ClientConnectionManager connManager = null;
        HttpParams params = this.getParams();
        ClientConnectionManagerFactory factory = null;
        String className = (String)params.getParameter("http.connection-manager.factory-class-name");
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                factory = (ClientConnectionManagerFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Invalid class name: " + className);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessError(ex.getMessage());
            }
            catch (InstantiationException ex) {
                throw new InstantiationError(ex.getMessage());
            }
        }
        connManager = factory != null ? factory.newInstance(params, registry) : new SingleClientConnManager(this.getParams(), registry);
        return connManager;
    }

    protected HttpContext createHttpContext() {
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.scheme-registry", this.getConnectionManager().getSchemeRegistry());
        context.setAttribute("http.authscheme-registry", this.getAuthSchemes());
        context.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
        context.setAttribute("http.cookie-store", this.getCookieStore());
        context.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
        return context;
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        AuthSchemeRegistry registry = new AuthSchemeRegistry();
        registry.register("Basic", new BasicSchemeFactory());
        registry.register("Digest", new DigestSchemeFactory());
        return registry;
    }

    protected CookieSpecRegistry createCookieSpecRegistry() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register("best-match", new BestMatchSpecFactory());
        registry.register("compatibility", new BrowserCompatSpecFactory());
        registry.register("netscape", new NetscapeDraftSpecFactory());
        registry.register("rfc2109", new RFC2109SpecFactory());
        registry.register("rfc2965", new RFC2965SpecFactory());
        return registry;
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler();
    }

    protected RedirectHandler createRedirectHandler() {
        return new DefaultRedirectHandler();
    }

    protected AuthenticationHandler createTargetAuthenticationHandler() {
        return new DefaultTargetAuthenticationHandler();
    }

    protected AuthenticationHandler createProxyAuthenticationHandler() {
        return new DefaultProxyAuthenticationHandler();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }
}

