/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PseudoKinds {
    private final Map<String, PseudoKind> pseudoKinds = new MapMaker().makeMap();

    PseudoKinds() {
    }

    void register(PseudoKind implementation) {
        Preconditions.checkNotNull((Object)implementation);
        PseudoKind previous = this.pseudoKinds.put(implementation.getKindName(), implementation);
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (Object)("duplicate registration for pseudo-kind " + implementation.getKindName()));
    }

    List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query) {
        Preconditions.checkNotNull((Object)query);
        PseudoKind pseudoKind = this.pseudoKinds.get(query.getKind());
        if (pseudoKind == null) {
            return null;
        }
        query.clearKind();
        List<OnestoreEntity.EntityProto> results = pseudoKind.runQuery(query);
        Preconditions.checkNotNull(results, (Object)("pseudo-kind " + pseudoKind.getKindName() + " returned invalid result"));
        return results;
    }
}

