/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * The TableConstraints defines the primary key and foreign key.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableConstraints extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Present only if the table has a foreign key. The foreign key is not enforced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ForeignKeys> foreignKeys;

  static {
    // hack to force ProGuard to consider ForeignKeys used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ForeignKeys.class);
  }

  /**
   * Represents the primary key constraint on a table's columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PrimaryKey primaryKey;

  /**
   * Optional. Present only if the table has a foreign key. The foreign key is not enforced.
   * @return value or {@code null} for none
   */
  public java.util.List<ForeignKeys> getForeignKeys() {
    return foreignKeys;
  }

  /**
   * Optional. Present only if the table has a foreign key. The foreign key is not enforced.
   * @param foreignKeys foreignKeys or {@code null} for none
   */
  public TableConstraints setForeignKeys(java.util.List<ForeignKeys> foreignKeys) {
    this.foreignKeys = foreignKeys;
    return this;
  }

  /**
   * Represents the primary key constraint on a table's columns.
   * @return value or {@code null} for none
   */
  public PrimaryKey getPrimaryKey() {
    return primaryKey;
  }

  /**
   * Represents the primary key constraint on a table's columns.
   * @param primaryKey primaryKey or {@code null} for none
   */
  public TableConstraints setPrimaryKey(PrimaryKey primaryKey) {
    this.primaryKey = primaryKey;
    return this;
  }

  @Override
  public TableConstraints set(String fieldName, Object value) {
    return (TableConstraints) super.set(fieldName, value);
  }

  @Override
  public TableConstraints clone() {
    return (TableConstraints) super.clone();
  }

  /**
   * Represents a foreign key constraint on a table's columns.
   */
  public static final class ForeignKeys extends com.google.api.client.json.GenericJson {

    /**
     * Required. The columns that compose the foreign key.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<ColumnReferences> columnReferences;

    static {
      // hack to force ProGuard to consider ColumnReferences used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(ColumnReferences.class);
    }

    /**
     * Optional. Set only if the foreign key constraint is named.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private ReferencedTable referencedTable;

    /**
     * Required. The columns that compose the foreign key.
     * @return value or {@code null} for none
     */
    public java.util.List<ColumnReferences> getColumnReferences() {
      return columnReferences;
    }

    /**
     * Required. The columns that compose the foreign key.
     * @param columnReferences columnReferences or {@code null} for none
     */
    public ForeignKeys setColumnReferences(java.util.List<ColumnReferences> columnReferences) {
      this.columnReferences = columnReferences;
      return this;
    }

    /**
     * Optional. Set only if the foreign key constraint is named.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * Optional. Set only if the foreign key constraint is named.
     * @param name name or {@code null} for none
     */
    public ForeignKeys setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public ReferencedTable getReferencedTable() {
      return referencedTable;
    }

    /**
     * @param referencedTable referencedTable or {@code null} for none
     */
    public ForeignKeys setReferencedTable(ReferencedTable referencedTable) {
      this.referencedTable = referencedTable;
      return this;
    }

    @Override
    public ForeignKeys set(String fieldName, Object value) {
      return (ForeignKeys) super.set(fieldName, value);
    }

    @Override
    public ForeignKeys clone() {
      return (ForeignKeys) super.clone();
    }

    /**
     * The pair of the foreign key column and primary key column.
     */
    public static final class ColumnReferences extends com.google.api.client.json.GenericJson {

      /**
       * Required. The column in the primary key that are referenced by the referencing_column.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String referencedColumn;

      /**
       * Required. The column that composes the foreign key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String referencingColumn;

      /**
       * Required. The column in the primary key that are referenced by the referencing_column.
       * @return value or {@code null} for none
       */
      public java.lang.String getReferencedColumn() {
        return referencedColumn;
      }

      /**
       * Required. The column in the primary key that are referenced by the referencing_column.
       * @param referencedColumn referencedColumn or {@code null} for none
       */
      public ColumnReferences setReferencedColumn(java.lang.String referencedColumn) {
        this.referencedColumn = referencedColumn;
        return this;
      }

      /**
       * Required. The column that composes the foreign key.
       * @return value or {@code null} for none
       */
      public java.lang.String getReferencingColumn() {
        return referencingColumn;
      }

      /**
       * Required. The column that composes the foreign key.
       * @param referencingColumn referencingColumn or {@code null} for none
       */
      public ColumnReferences setReferencingColumn(java.lang.String referencingColumn) {
        this.referencingColumn = referencingColumn;
        return this;
      }

      @Override
      public ColumnReferences set(String fieldName, Object value) {
        return (ColumnReferences) super.set(fieldName, value);
      }

      @Override
      public ColumnReferences clone() {
        return (ColumnReferences) super.clone();
      }

    }
    /**
     * Model definition for TableConstraintsForeignKeysReferencedTable.
     */
    public static final class ReferencedTable extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /**
       * @param datasetId datasetId or {@code null} for none
       */
      public ReferencedTable setDatasetId(java.lang.String datasetId) {
        this.datasetId = datasetId;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /**
       * @param projectId projectId or {@code null} for none
       */
      public ReferencedTable setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /**
       * @param tableId tableId or {@code null} for none
       */
      public ReferencedTable setTableId(java.lang.String tableId) {
        this.tableId = tableId;
        return this;
      }

      @Override
      public ReferencedTable set(String fieldName, Object value) {
        return (ReferencedTable) super.set(fieldName, value);
      }

      @Override
      public ReferencedTable clone() {
        return (ReferencedTable) super.clone();
      }

    }
  }

  /**
   * Represents the primary key constraint on a table's columns.
   */
  public static final class PrimaryKey extends com.google.api.client.json.GenericJson {

    /**
     * Required. The columns that are composed of the primary key constraint.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> columns;

    /**
     * Required. The columns that are composed of the primary key constraint.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getColumns() {
      return columns;
    }

    /**
     * Required. The columns that are composed of the primary key constraint.
     * @param columns columns or {@code null} for none
     */
    public PrimaryKey setColumns(java.util.List<java.lang.String> columns) {
      this.columns = columns;
      return this;
    }

    @Override
    public PrimaryKey set(String fieldName, Object value) {
      return (PrimaryKey) super.set(fieldName, value);
    }

    @Override
    public PrimaryKey clone() {
      return (PrimaryKey) super.clone();
    }

  }
}
