/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Details about source stages which produce skewed data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SkewSource extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Stage id of the skew source stage.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long stageId;

  /**
   * Output only. Stage id of the skew source stage.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStageId() {
    return stageId;
  }

  /**
   * Output only. Stage id of the skew source stage.
   * @param stageId stageId or {@code null} for none
   */
  public SkewSource setStageId(java.lang.Long stageId) {
    this.stageId = stageId;
    return this;
  }

  @Override
  public SkewSource set(String fieldName, Object value) {
    return (SkewSource) super.set(fieldName, value);
  }

  @Override
  public SkewSource clone() {
    return (SkewSource) super.clone();
  }

}
