/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Evaluation metrics used by weighted-ALS models specified by feedback_type=implicit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RankingMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Determines the goodness of a ranking by computing the percentile rank from the predicted
   * confidence and dividing it by the original rank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double averageRank;

  /**
   * Calculates a precision per user for all the items by ranking them and then averages all the
   * precisions across all the users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double meanAveragePrecision;

  /**
   * Similar to the mean squared error computed in regression and explicit recommendation models
   * except instead of computing the rating directly, the output from evaluate is computed against a
   * preference which is 1 or 0 depending on if the rating exists or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double meanSquaredError;

  /**
   * A metric to determine the goodness of a ranking calculated from the predicted confidence by
   * comparing it to an ideal rank measured by the original ratings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double normalizedDiscountedCumulativeGain;

  /**
   * Determines the goodness of a ranking by computing the percentile rank from the predicted
   * confidence and dividing it by the original rank.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAverageRank() {
    return averageRank;
  }

  /**
   * Determines the goodness of a ranking by computing the percentile rank from the predicted
   * confidence and dividing it by the original rank.
   * @param averageRank averageRank or {@code null} for none
   */
  public RankingMetrics setAverageRank(java.lang.Double averageRank) {
    this.averageRank = averageRank;
    return this;
  }

  /**
   * Calculates a precision per user for all the items by ranking them and then averages all the
   * precisions across all the users.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMeanAveragePrecision() {
    return meanAveragePrecision;
  }

  /**
   * Calculates a precision per user for all the items by ranking them and then averages all the
   * precisions across all the users.
   * @param meanAveragePrecision meanAveragePrecision or {@code null} for none
   */
  public RankingMetrics setMeanAveragePrecision(java.lang.Double meanAveragePrecision) {
    this.meanAveragePrecision = meanAveragePrecision;
    return this;
  }

  /**
   * Similar to the mean squared error computed in regression and explicit recommendation models
   * except instead of computing the rating directly, the output from evaluate is computed against a
   * preference which is 1 or 0 depending on if the rating exists or not.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMeanSquaredError() {
    return meanSquaredError;
  }

  /**
   * Similar to the mean squared error computed in regression and explicit recommendation models
   * except instead of computing the rating directly, the output from evaluate is computed against a
   * preference which is 1 or 0 depending on if the rating exists or not.
   * @param meanSquaredError meanSquaredError or {@code null} for none
   */
  public RankingMetrics setMeanSquaredError(java.lang.Double meanSquaredError) {
    this.meanSquaredError = meanSquaredError;
    return this;
  }

  /**
   * A metric to determine the goodness of a ranking calculated from the predicted confidence by
   * comparing it to an ideal rank measured by the original ratings.
   * @return value or {@code null} for none
   */
  public java.lang.Double getNormalizedDiscountedCumulativeGain() {
    return normalizedDiscountedCumulativeGain;
  }

  /**
   * A metric to determine the goodness of a ranking calculated from the predicted confidence by
   * comparing it to an ideal rank measured by the original ratings.
   * @param normalizedDiscountedCumulativeGain normalizedDiscountedCumulativeGain or {@code null} for none
   */
  public RankingMetrics setNormalizedDiscountedCumulativeGain(java.lang.Double normalizedDiscountedCumulativeGain) {
    this.normalizedDiscountedCumulativeGain = normalizedDiscountedCumulativeGain;
    return this;
  }

  @Override
  public RankingMetrics set(String fieldName, Object value) {
    return (RankingMetrics) super.set(fieldName, value);
  }

  @Override
  public RankingMetrics clone() {
    return (RankingMetrics) super.clone();
  }

}
