/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * The partitioning information, which includes managed table, external table and metastore
 * partitioned table partition information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PartitioningDefinition extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Details about each partitioning column. This field is output only for all
   * partitioning types other than metastore partitioned tables. BigQuery native tables only support
   * 1 partitioning column. Other table types may support 0, 1 or more partitioning columns. For
   * metastore partitioned tables, the order must match the definition order in the Hive Metastore,
   * where it must match the physical layout of the table. For example, CREATE TABLE a_table(id
   * BIGINT, name STRING) PARTITIONED BY (city STRING, state STRING). In this case the values must
   * be ['city', 'state'] in that order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PartitionedColumn> partitionedColumn;

  static {
    // hack to force ProGuard to consider PartitionedColumn used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PartitionedColumn.class);
  }

  /**
   * Optional. Details about each partitioning column. This field is output only for all
   * partitioning types other than metastore partitioned tables. BigQuery native tables only support
   * 1 partitioning column. Other table types may support 0, 1 or more partitioning columns. For
   * metastore partitioned tables, the order must match the definition order in the Hive Metastore,
   * where it must match the physical layout of the table. For example, CREATE TABLE a_table(id
   * BIGINT, name STRING) PARTITIONED BY (city STRING, state STRING). In this case the values must
   * be ['city', 'state'] in that order.
   * @return value or {@code null} for none
   */
  public java.util.List<PartitionedColumn> getPartitionedColumn() {
    return partitionedColumn;
  }

  /**
   * Optional. Details about each partitioning column. This field is output only for all
   * partitioning types other than metastore partitioned tables. BigQuery native tables only support
   * 1 partitioning column. Other table types may support 0, 1 or more partitioning columns. For
   * metastore partitioned tables, the order must match the definition order in the Hive Metastore,
   * where it must match the physical layout of the table. For example, CREATE TABLE a_table(id
   * BIGINT, name STRING) PARTITIONED BY (city STRING, state STRING). In this case the values must
   * be ['city', 'state'] in that order.
   * @param partitionedColumn partitionedColumn or {@code null} for none
   */
  public PartitioningDefinition setPartitionedColumn(java.util.List<PartitionedColumn> partitionedColumn) {
    this.partitionedColumn = partitionedColumn;
    return this;
  }

  @Override
  public PartitioningDefinition set(String fieldName, Object value) {
    return (PartitioningDefinition) super.set(fieldName, value);
  }

  @Override
  public PartitioningDefinition clone() {
    return (PartitioningDefinition) super.clone();
  }

}
