/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model evaluation metrics for a single ARIMA forecasting model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ArimaSingleModelForecastingMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Arima fitting metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaFittingMetrics arimaFittingMetrics;

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasDrift;

  /**
   * If true, holiday_effect is a part of time series decomposition result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasHolidayEffect;

  /**
   * If true, spikes_and_dips is a part of time series decomposition result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasSpikesAndDips;

  /**
   * If true, step_changes is a part of time series decomposition result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasStepChanges;

  /**
   * Non-seasonal order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ArimaOrder nonSeasonalOrder;

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> seasonalPeriods;

  /**
   * The time_series_id value for this time series. It will be one of the unique values from the
   * time_series_id_column specified during ARIMA model training. Only present when
   * time_series_id_column training option was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeSeriesId;

  /**
   * The tuple of time_series_ids identifying this time series. It will be one of the unique tuples
   * of values present in the time_series_id_columns specified during ARIMA model training. Only
   * present when time_series_id_columns training option was used and the order of values here are
   * same as the order of time_series_id_columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> timeSeriesIds;

  /**
   * Arima fitting metrics.
   * @return value or {@code null} for none
   */
  public ArimaFittingMetrics getArimaFittingMetrics() {
    return arimaFittingMetrics;
  }

  /**
   * Arima fitting metrics.
   * @param arimaFittingMetrics arimaFittingMetrics or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setArimaFittingMetrics(ArimaFittingMetrics arimaFittingMetrics) {
    this.arimaFittingMetrics = arimaFittingMetrics;
    return this;
  }

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasDrift() {
    return hasDrift;
  }

  /**
   * Is arima model fitted with drift or not. It is always false when d is not 1.
   * @param hasDrift hasDrift or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setHasDrift(java.lang.Boolean hasDrift) {
    this.hasDrift = hasDrift;
    return this;
  }

  /**
   * If true, holiday_effect is a part of time series decomposition result.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasHolidayEffect() {
    return hasHolidayEffect;
  }

  /**
   * If true, holiday_effect is a part of time series decomposition result.
   * @param hasHolidayEffect hasHolidayEffect or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setHasHolidayEffect(java.lang.Boolean hasHolidayEffect) {
    this.hasHolidayEffect = hasHolidayEffect;
    return this;
  }

  /**
   * If true, spikes_and_dips is a part of time series decomposition result.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasSpikesAndDips() {
    return hasSpikesAndDips;
  }

  /**
   * If true, spikes_and_dips is a part of time series decomposition result.
   * @param hasSpikesAndDips hasSpikesAndDips or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setHasSpikesAndDips(java.lang.Boolean hasSpikesAndDips) {
    this.hasSpikesAndDips = hasSpikesAndDips;
    return this;
  }

  /**
   * If true, step_changes is a part of time series decomposition result.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasStepChanges() {
    return hasStepChanges;
  }

  /**
   * If true, step_changes is a part of time series decomposition result.
   * @param hasStepChanges hasStepChanges or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setHasStepChanges(java.lang.Boolean hasStepChanges) {
    this.hasStepChanges = hasStepChanges;
    return this;
  }

  /**
   * Non-seasonal order.
   * @return value or {@code null} for none
   */
  public ArimaOrder getNonSeasonalOrder() {
    return nonSeasonalOrder;
  }

  /**
   * Non-seasonal order.
   * @param nonSeasonalOrder nonSeasonalOrder or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setNonSeasonalOrder(ArimaOrder nonSeasonalOrder) {
    this.nonSeasonalOrder = nonSeasonalOrder;
    return this;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSeasonalPeriods() {
    return seasonalPeriods;
  }

  /**
   * Seasonal periods. Repeated because multiple periods are supported for one time series.
   * @param seasonalPeriods seasonalPeriods or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setSeasonalPeriods(java.util.List<java.lang.String> seasonalPeriods) {
    this.seasonalPeriods = seasonalPeriods;
    return this;
  }

  /**
   * The time_series_id value for this time series. It will be one of the unique values from the
   * time_series_id_column specified during ARIMA model training. Only present when
   * time_series_id_column training option was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeSeriesId() {
    return timeSeriesId;
  }

  /**
   * The time_series_id value for this time series. It will be one of the unique values from the
   * time_series_id_column specified during ARIMA model training. Only present when
   * time_series_id_column training option was used.
   * @param timeSeriesId timeSeriesId or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setTimeSeriesId(java.lang.String timeSeriesId) {
    this.timeSeriesId = timeSeriesId;
    return this;
  }

  /**
   * The tuple of time_series_ids identifying this time series. It will be one of the unique tuples
   * of values present in the time_series_id_columns specified during ARIMA model training. Only
   * present when time_series_id_columns training option was used and the order of values here are
   * same as the order of time_series_id_columns.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTimeSeriesIds() {
    return timeSeriesIds;
  }

  /**
   * The tuple of time_series_ids identifying this time series. It will be one of the unique tuples
   * of values present in the time_series_id_columns specified during ARIMA model training. Only
   * present when time_series_id_columns training option was used and the order of values here are
   * same as the order of time_series_id_columns.
   * @param timeSeriesIds timeSeriesIds or {@code null} for none
   */
  public ArimaSingleModelForecastingMetrics setTimeSeriesIds(java.util.List<java.lang.String> timeSeriesIds) {
    this.timeSeriesIds = timeSeriesIds;
    return this;
  }

  @Override
  public ArimaSingleModelForecastingMetrics set(String fieldName, Object value) {
    return (ArimaSingleModelForecastingMetrics) super.set(fieldName, value);
  }

  @Override
  public ArimaSingleModelForecastingMetrics clone() {
    return (ArimaSingleModelForecastingMetrics) super.clone();
  }

}
