/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.NestedRulesCollector;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.compiler.stages.ScopeExtractor;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.List;

public class LessToCssCompiler {
    private ProblemsHandler problemsHandler;

    public LessToCssCompiler(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public ASTCssNode compileToCss(StyleSheet less) {
        ScopeExtractor scopeBuilder = new ScopeExtractor();
        Scope scope = scopeBuilder.extractScope(less);
        ReferencesSolver referencesSolver = new ReferencesSolver(this.problemsHandler);
        referencesSolver.solveReferences(less, scope);
        this.evaluateExpressions(less);
        this.freeNestedRuleSets(less);
        return less;
    }

    private void freeNestedRuleSets(Body<ASTCssNode> body) {
        NestedRulesCollector nestedRulesCollector = new NestedRulesCollector();
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(body.getChilds());
        block6: for (ASTCssNode kid : childs) {
            switch (kid.getType()) {
                case RULE_SET: {
                    List<RuleSet> nestedRulesets = nestedRulesCollector.collectNestedRuleSets((RuleSet)kid);
                    body.addMembersAfter(nestedRulesets, kid);
                    for (RuleSet ruleSet : nestedRulesets) {
                        ruleSet.setParent(body);
                    }
                    continue block6;
                }
                case MEDIA: {
                    this.freeNestedRuleSets((Media)kid);
                    break;
                }
                case PAGE: {
                    Page page = (Page)kid;
                    this.freeNestedRuleSets(page.getBody());
                    break;
                }
                case PAGE_MARGIN_BOX: {
                    PageMarginBox marginBox = (PageMarginBox)kid;
                    this.freeNestedRuleSets(marginBox.getBody());
                    break;
                }
            }
        }
    }

    private void evaluateExpressions(ASTCssNode node) {
        ASTManipulator manipulator = new ASTManipulator();
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(this.problemsHandler);
        if (node instanceof Expression) {
            Expression value = expressionEvaluator.evaluate((Expression)node);
            manipulator.replace(node, value);
        } else {
            List<? extends ASTCssNode> childs = node.getChilds();
            block4: for (ASTCssNode aSTCssNode : childs) {
                switch (aSTCssNode.getType()) {
                    case MEDIA_EXPRESSION: {
                        this.evaluateInMediaExpressions((MediaExpression)aSTCssNode);
                        continue block4;
                    }
                    case DECLARATION: {
                        this.evaluateInDeclaration((Declaration)aSTCssNode);
                        continue block4;
                    }
                }
                this.evaluateExpressions(aSTCssNode);
            }
        }
    }

    private void evaluateInDeclaration(Declaration node) {
        if (!node.isFontDeclaration()) {
            this.evaluateExpressions(node);
            return;
        }
    }

    private void evaluateInMediaExpressions(MediaExpression node) {
        MediaExpressionFeature feature = node.getFeature();
        if (!feature.isRatioFeature()) {
            this.evaluateExpressions(node);
            return;
        }
    }
}

