/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;

public class AstValidator {
    private final ProblemsHandler problemsHandler;

    public AstValidator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void validate(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                this.checkEmptySelector((RuleSet)node);
                break;
            }
            case MIXIN_REFERENCE: {
                this.checkComposedSimpleMixinName((MixinReference)node);
                break;
            }
            case PSEUDO_CLASS: {
                this.checkDeprecatedParameterType((PseudoClass)node);
                break;
            }
            case ESCAPED_SELECTOR: {
                this.problemsHandler.deprecatedSyntaxEscapedSelector((EscapedSelector)node);
            }
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.validate(aSTCssNode);
        }
    }

    private void checkComposedSimpleMixinName(MixinReference reference) {
        if (!reference.getSelector().isSimple()) {
            this.problemsHandler.composedMixinReferenceSelector(reference);
        }
    }

    private void checkDeprecatedParameterType(PseudoClass pseudo) {
        ASTCssNode parameter = pseudo.getParameter();
        if (parameter != null && parameter.getType() == ASTCssNodeType.VARIABLE) {
            this.problemsHandler.variableAsPseudoclassParameter(pseudo);
        }
    }

    private void checkEmptySelector(RuleSet ruleSet) {
        if (ruleSet.getSelectors() == null || ruleSet.getSelectors().isEmpty()) {
            this.problemsHandler.rulesetWithoutSelector(ruleSet);
        }
    }
}

