/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

abstract class RoundingFunction
implements Function {
    RoundingFunction() {
    }

    @Override
    public final Expression evaluate(Expression iParameter, ProblemsHandler problemsHandler) {
        if (iParameter.getType() != ASTCssNodeType.NUMBER) {
            problemsHandler.mathFunctionParameterNotANumber(this.getName(), iParameter);
            return new FaultyExpression(iParameter);
        }
        NumberExpression parameter = (NumberExpression)iParameter;
        HiddenTokenAwareTree parentToken = parameter.getUnderlyingStructure();
        Double oValue = parameter.getValueAsDouble();
        String suffix = parameter.getSuffix();
        NumberExpression.Dimension dimension = parameter.getDimension();
        if (oValue.isInfinite() || oValue.isNaN()) {
            return new NumberExpression(parentToken, oValue, suffix, null, dimension);
        }
        return this.calc(parentToken, oValue, suffix, dimension);
    }

    protected abstract String getName();

    protected abstract Expression calc(HiddenTokenAwareTree var1, Double var2, String var3, NumberExpression.Dimension var4);
}

