/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar.maven;

import com.github.os72.protocjar.PlatformDetector;
import com.github.os72.protocjar.Protoc;
import com.github.os72.protocjar.ProtocVersion;
import com.github.os72.protocjar.maven.OutputTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocJarMojo
extends AbstractMojo {
    private static final String DEFAULT_INPUT_DIR = "/src/main/protobuf/".replace('/', File.separatorChar);
    private String protocVersion;
    private File[] inputDirectories;
    private File[] includeDirectories;
    private boolean includeStdTypes;
    private String type;
    private String addSources;
    private boolean cleanOutputFolder;
    private String pluginPath;
    private String pluginArtifact;
    private File outputDirectory;
    private String outputDirectorySuffix;
    private String outputOptions;
    private OutputTarget[] outputTargets;
    private String extension;
    private String protocCommand;
    private String protocArtifact;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private BuildContext buildContext;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private File tempRoot = null;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging() != null && "pom".equals(this.project.getPackaging().toLowerCase())) {
            this.getLog().info((CharSequence)"Skipping 'pom' packaged project");
            return;
        }
        if (this.outputTargets == null || this.outputTargets.length == 0) {
            OutputTarget target = new OutputTarget();
            target.type = this.type;
            target.addSources = this.addSources;
            target.cleanOutputFolder = this.cleanOutputFolder;
            target.pluginPath = this.pluginPath;
            target.pluginArtifact = this.pluginArtifact;
            target.outputDirectory = this.outputDirectory;
            target.outputDirectorySuffix = this.outputDirectorySuffix;
            target.outputOptions = this.outputOptions;
            this.outputTargets = new OutputTarget[]{target};
        }
        for (OutputTarget target : this.outputTargets) {
            target.addSources = target.addSources.toLowerCase().trim();
            if ("true".equals(target.addSources)) {
                target.addSources = "main";
            }
            if (target.outputDirectory == null) {
                String subdir = "generated-" + ("test".equals(target.addSources) ? "test-" : "") + "sources";
                target.outputDirectory = new File(this.project.getBuild().getDirectory() + File.separator + subdir + File.separator);
            }
            if (target.outputDirectorySuffix == null) continue;
            target.outputDirectory = new File(target.outputDirectory, target.outputDirectorySuffix);
        }
        this.performProtoCompilation();
    }

    private void performProtoCompilation() throws MojoExecutionException {
        File stdTypeDir;
        block24: {
            if (this.protocCommand != null) {
                try {
                    Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
                }
                catch (Exception e) {
                    this.protocCommand = null;
                }
            }
            stdTypeDir = null;
            if (this.protocCommand == null && this.protocArtifact == null || this.includeStdTypes) {
                if (this.protocVersion == null || this.protocVersion.length() < 1) {
                    this.protocVersion = ProtocVersion.PROTOC_VERSION.mVersion;
                }
                this.getLog().info((CharSequence)("Protoc version: " + this.protocVersion));
                try {
                    if (this.protocCommand == null && this.protocArtifact == null) {
                        File protocFile = Protoc.extractProtoc(ProtocVersion.getVersion("-v" + this.protocVersion), this.includeStdTypes);
                        this.protocCommand = protocFile.getAbsolutePath();
                        try {
                            Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
                        }
                        catch (Exception e) {
                            this.tempRoot = new File(System.getProperty("user.home"));
                            protocFile = Protoc.extractProtoc(ProtocVersion.getVersion("-v" + this.protocVersion), this.includeStdTypes, this.tempRoot);
                            this.protocCommand = protocFile.getAbsolutePath();
                        }
                        stdTypeDir = new File(protocFile.getParentFile().getParentFile(), "include");
                        break block24;
                    }
                    if (this.includeStdTypes) {
                        File tmpDir = Protoc.extractStdTypes(ProtocVersion.getVersion("-v" + this.protocVersion), null);
                        stdTypeDir = new File(tmpDir, "include");
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error extracting protoc for version " + this.protocVersion, (Exception)e);
                }
            }
        }
        if (this.protocCommand == null && this.protocArtifact != null) {
            this.protocCommand = this.resolveArtifact(this.protocArtifact, null).getAbsolutePath();
            try {
                Protoc.runProtoc(this.protocCommand, new String[]{"--version"});
            }
            catch (Exception e) {
                this.tempRoot = new File(System.getProperty("user.home"));
                this.protocCommand = this.resolveArtifact(this.protocArtifact, this.tempRoot).getAbsolutePath();
            }
        }
        this.getLog().info((CharSequence)("Protoc command: " + this.protocCommand));
        if (this.inputDirectories == null || this.inputDirectories.length == 0) {
            File inputDir = new File(this.project.getBasedir().getAbsolutePath() + DEFAULT_INPUT_DIR);
            this.inputDirectories = new File[]{inputDir};
        }
        this.getLog().info((CharSequence)"Input directories:");
        for (File file : this.inputDirectories) {
            this.getLog().info((CharSequence)("    " + file));
        }
        if (this.includeStdTypes) {
            if (this.includeDirectories != null && this.includeDirectories.length > 0) {
                ArrayList<File> includeDirList = new ArrayList<File>();
                includeDirList.add(stdTypeDir);
                includeDirList.addAll(Arrays.asList(this.includeDirectories));
                this.includeDirectories = includeDirList.toArray(new File[0]);
            } else {
                this.includeDirectories = new File[]{stdTypeDir};
            }
        }
        if (this.includeDirectories != null && this.includeDirectories.length > 0) {
            this.getLog().info((CharSequence)"Include directories:");
            for (File file : this.includeDirectories) {
                this.getLog().info((CharSequence)("    " + file));
            }
        }
        this.getLog().info((CharSequence)"Output targets:");
        for (OutputTarget outputTarget : this.outputTargets) {
            this.getLog().info((CharSequence)("    " + outputTarget));
        }
        for (OutputTarget outputTarget : this.outputTargets) {
            this.preprocessTarget(outputTarget);
        }
        for (OutputTarget outputTarget : this.outputTargets) {
            this.processTarget(outputTarget);
        }
    }

    private void preprocessTarget(OutputTarget target) throws MojoExecutionException {
        File f;
        if (target.pluginArtifact != null && target.pluginArtifact.length() > 0) {
            target.pluginPath = this.resolveArtifact(target.pluginArtifact, this.tempRoot).getAbsolutePath();
        }
        if (!(f = target.outputDirectory).exists()) {
            this.getLog().info((CharSequence)(f + " does not exist. Creating..."));
            f.mkdirs();
        }
        if (target.cleanOutputFolder) {
            try {
                this.getLog().info((CharSequence)("Cleaning " + f));
                FileUtils.cleanDirectory((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processTarget(OutputTarget target) throws MojoExecutionException {
        boolean shaded = false;
        String targetType = target.type;
        if (targetType.equals("java-shaded") || targetType.equals("java_shaded")) {
            targetType = "java";
            shaded = true;
        }
        FileFilter fileFilter = new FileFilter(this.extension);
        for (File input : this.inputDirectories) {
            if (input == null) continue;
            if (input.exists() && input.isDirectory()) {
                Collection protoFiles = FileUtils.listFiles((File)input, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
                for (File protoFile : protoFiles) {
                    if (target.cleanOutputFolder || this.buildContext.hasDelta(protoFile.getPath())) {
                        this.processFile(protoFile, this.protocVersion, targetType, target.pluginPath, target.outputDirectory, target.outputOptions);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Not changed " + protoFile));
                }
                continue;
            }
            if (input.exists()) {
                this.getLog().warn((CharSequence)(input + " is not a directory"));
                continue;
            }
            this.getLog().warn((CharSequence)(input + " does not exist"));
        }
        if (shaded) {
            try {
                this.getLog().info((CharSequence)("    Shading (version " + this.protocVersion + "): " + target.outputDirectory));
                Protoc.doShading(target.outputDirectory, this.protocVersion.replace(".", ""));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error occurred during shading", (Exception)e);
            }
        }
        boolean mainAddSources = "main".endsWith(target.addSources);
        boolean testAddSources = "test".endsWith(target.addSources);
        if (mainAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to classpath");
            this.project.addCompileSourceRoot(target.outputDirectory.getAbsolutePath());
        }
        if (testAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to test classpath");
            this.project.addTestCompileSourceRoot(target.outputDirectory.getAbsolutePath());
        }
        if (mainAddSources || testAddSources) {
            this.buildContext.refresh(target.outputDirectory);
        }
    }

    private void processFile(File file, String version, String type, String pluginPath, File outputDir, String outputOptions) throws MojoExecutionException {
        this.getLog().info((CharSequence)("    Processing (" + type + "): " + file.getName()));
        Collection<String> cmd = this.buildCommand(file, version, type, pluginPath, outputDir, outputOptions);
        try {
            int ret = 0;
            ret = this.protocCommand == null ? Protoc.runProtoc(cmd.toArray(new String[0])) : Protoc.runProtoc(this.protocCommand, cmd.toArray(new String[0]));
            if (ret != 0) {
                throw new MojoExecutionException("protoc-jar failed for " + file + ". Exit code " + ret);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute protoc-jar for " + file, (Exception)e);
        }
    }

    private Collection<String> buildCommand(File file, String version, String type, String pluginPath, File outputDir, String outputOptions) throws MojoExecutionException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.populateIncludes(cmd);
        cmd.add("-I" + file.getParentFile().getAbsolutePath());
        if ("descriptor".equals(type)) {
            File outFile = new File(outputDir, file.getName());
            cmd.add("--descriptor_set_out=" + FilenameUtils.removeExtension((String)outFile.toString()) + ".desc");
            cmd.add("--include_imports");
            if (outputOptions != null) {
                for (String arg : outputOptions.split("\\s+")) {
                    cmd.add(arg);
                }
            }
        } else {
            if (outputOptions != null) {
                cmd.add("--" + type + "_out=" + outputOptions + ":" + outputDir);
            } else {
                cmd.add("--" + type + "_out=" + outputDir);
            }
            if (pluginPath != null) {
                this.getLog().info((CharSequence)("    Plugin path: " + pluginPath));
                cmd.add("--plugin=protoc-gen-" + type + "=" + pluginPath);
            }
        }
        cmd.add(file.toString());
        if (version != null) {
            cmd.add("-v" + version);
        }
        return cmd;
    }

    private void populateIncludes(Collection<String> args) throws MojoExecutionException {
        for (File include : this.includeDirectories) {
            if (!include.exists()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' does not exist");
            }
            if (!include.isDirectory()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' is not a directory");
            }
            args.add("-I" + include.getPath());
        }
    }

    private File resolveArtifact(String artifactSpec, File dir) throws MojoExecutionException {
        try {
            Properties detectorProps = new Properties();
            new PlatformDetector().detect(detectorProps, null);
            String platform = detectorProps.getProperty("os.detected.classifier");
            this.getLog().info((CharSequence)("Resolving artifact: " + artifactSpec + ", platform: " + platform));
            String[] as = artifactSpec.split(":");
            Artifact artifact = this.artifactFactory.createDependencyArtifact(as[0], as[1], VersionRange.createFromVersionSpec((String)as[2]), "exe", platform, "runtime");
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            File tempFile = File.createTempFile(as[1], ".exe", dir);
            ProtocJarMojo.copyFile(artifact.getFile(), tempFile);
            tempFile.setExecutable(true);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error resolving artifact: " + artifactSpec, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(destFile);
            int read = 0;
            byte[] buf = new byte[4096];
            while ((read = is.read(buf)) > 0) {
                os.write(buf, 0, read);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return destFile;
    }

    static class FileFilter
    implements IOFileFilter {
        String extension;

        public FileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }

        public boolean accept(File file) {
            return file.getName().endsWith(this.extension);
        }
    }
}

