/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.optionalusertools.TimeVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.privatejgoodies.forms.factories.CC;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TimeMenuPanel
extends JPanel {
    private DefaultListModel timeListModel;
    private TimePicker parentTimePicker;
    private TimePickerSettings settings;
    private JScrollPane timeScrollPane;
    private JList timeList;

    public TimeMenuPanel(TimePicker parentTimePicker, TimePickerSettings settings) {
        this.parentTimePicker = parentTimePicker;
        this.settings = settings;
        this.initComponents();
        this.timeListModel = new DefaultListModel();
        this.timeList.setModel(this.timeListModel);
        this.timeList.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Point mousePositionRelativeToComponent = new Point(event.getX(), event.getY());
                int index = TimeMenuPanel.this.timeList.locationToIndex(mousePositionRelativeToComponent);
                if (index != -1 && index != TimeMenuPanel.this.timeList.getSelectedIndex()) {
                    TimeMenuPanel.this.timeList.setSelectedIndex(index);
                }
            }
        });
        this.timeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                TimeMenuPanel.this.mouseReleasedWhileTimeListIsOpen();
            }
        });
        this.timeList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    event.consume();
                    String selectedTimeString = (String)TimeMenuPanel.this.timeList.getSelectedValue();
                    if (selectedTimeString != null) {
                        TimeMenuPanel.this.userSelectedATime(selectedTimeString);
                    }
                }
            }
        });
        this.generateTimeEntriesFromSettings();
        int maximumMenuRows = Math.min(settings.maximumVisibleMenuRows, this.timeListModel.getSize());
        this.timeList.setVisibleRowCount(maximumMenuRows);
    }

    public void mouseDraggedFromToggleButton() {
        Point mousePositionRelativeToScreen = MouseInfo.getPointerInfo().getLocation();
        Rectangle timeListBounds = this.timeList.getBounds();
        timeListBounds.setLocation(this.timeList.getLocationOnScreen());
        if (timeListBounds.contains(mousePositionRelativeToScreen)) {
            SwingUtilities.convertPointFromScreen(mousePositionRelativeToScreen, this.timeList);
            Point mousePositionRelativeToComponent = (Point)mousePositionRelativeToScreen.clone();
            int index = this.timeList.locationToIndex(mousePositionRelativeToComponent);
            if (index != -1 && index != this.timeList.getSelectedIndex()) {
                this.timeList.setSelectedIndex(index);
            }
        }
    }

    public void mouseReleasedFromToggleButtonOutsideButton() {
        this.mouseReleasedWhileTimeListIsOpen();
    }

    private void mouseReleasedWhileTimeListIsOpen() {
        Point mousePositionRelativeToScreen = MouseInfo.getPointerInfo().getLocation();
        Rectangle timeListBounds = this.timeList.getBounds();
        timeListBounds.setLocation(this.timeList.getLocationOnScreen());
        if (!timeListBounds.contains(mousePositionRelativeToScreen)) {
            this.tryClosePopup();
            return;
        }
        Point mousePositionRelativeToComponent = this.timeList.getMousePosition();
        int index = this.timeList.locationToIndex(mousePositionRelativeToComponent);
        Rectangle cellBoundsOfIndex = this.timeList.getCellBounds(index, index);
        if (cellBoundsOfIndex == null || !cellBoundsOfIndex.contains(mousePositionRelativeToComponent)) {
            this.tryClosePopup();
            return;
        }
        try {
            String selectedTimeString = (String)this.timeList.getModel().getElementAt(index);
            if (selectedTimeString != null && !selectedTimeString.isEmpty()) {
                this.userSelectedATime(selectedTimeString);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("TimeMenuPanel.mouseReleasedWhileTimeListIsOpen() Time menu list index is out of bounds. This should not happen. " + e.getMessage());
        }
    }

    public void clearParent() {
        this.parentTimePicker = null;
        this.settings = null;
    }

    void generateTimeEntriesFromSettings() {
        this.timeListModel.clear();
        DateTimeFormatter formatForMenuTimes = this.settings.getFormatForMenuTimes();
        ArrayList<LocalTime> menuTimes = this.settings.getPotentialMenuTimes();
        for (LocalTime localTime : menuTimes) {
            if (InternalUtilities.isTimeVetoed(this.settings.getVetoPolicy(), localTime)) continue;
            String localizedTime = formatForMenuTimes.format(localTime);
            if (this.settings.useLowercaseForMenuTimes) {
                localizedTime = localizedTime.toLowerCase(this.settings.getLocale());
            }
            this.timeListModel.addElement(localizedTime);
        }
    }

    private void userSelectedATime(String selectedTimeString) {
        LocalTime selectedTime = InternalUtilities.getParsedTimeOrNull(selectedTimeString, this.settings.getFormatForDisplayTime(), this.settings.getFormatForMenuTimes(), this.settings.formatsForParsing, this.settings.getLocale());
        if (selectedTime == null) {
            throw new RuntimeException("TimeMenuPanel, Could not parse menu time. This should not happen.");
        }
        TimeVetoPolicy vetoPolicy = this.settings.getVetoPolicy();
        if (InternalUtilities.isTimeVetoed(vetoPolicy, selectedTime)) {
            return;
        }
        if (this.parentTimePicker != null) {
            this.parentTimePicker.setTime(selectedTime);
            this.parentTimePicker.closePopup();
        }
    }

    private void initComponents() {
        this.timeScrollPane = new JScrollPane();
        this.timeList = new JList();
        this.setBorder(null);
        this.setLayout(new FormLayout("default:grow", "fill:default:grow"));
        this.timeScrollPane.setHorizontalScrollBarPolicy(31);
        this.timeList.setSelectionMode(1);
        this.timeList.setVisibleRowCount(10);
        this.timeScrollPane.setViewportView(this.timeList);
        this.add((Component)this.timeScrollPane, CC.xy(1, 1));
    }

    private void tryClosePopup() {
        if (this.parentTimePicker != null) {
            this.parentTimePicker.closePopup();
        }
    }

    public void requestListFocus() {
        this.timeList.requestFocusInWindow();
    }

    public void selectFirstEntry() {
        if (this.timeList.getModel().getSize() > 0) {
            this.timeList.setSelectedIndex(0);
            this.timeList.requestFocusInWindow();
        }
    }
}

