/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.NamedObject;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UniqueList<T extends NamedObject>
extends AbstractList<T>
implements List<T> {
    private final Map<String, T> elementByName;
    private final List<T> list = new LinkedList<T>();

    public UniqueList() {
        this.elementByName = new HashMap<String, T>();
    }

    @Override
    public void add(int index, T element) {
        String elementName = element.getName();
        if (this.elementByName.containsKey(elementName)) {
            throw new IllegalArgumentException("Element " + element + " already in list");
        }
        this.elementByName.put(elementName, element);
        this.list.add(index, element);
    }

    @Override
    public T get(int index) {
        return (T)((NamedObject)this.list.get(index));
    }

    public T getByName(String name) {
        return (T)((NamedObject)this.elementByName.get(name));
    }

    public Set<String> nameSet() {
        return this.elementByName.keySet();
    }

    @Override
    public T remove(int index) {
        NamedObject element = (NamedObject)this.list.remove(index);
        this.elementByName.remove(element.getName());
        return (T)element;
    }

    @Override
    public boolean remove(Object o) {
        if (this.elementByName.containsValue(o)) {
            this.elementByName.remove(((NamedObject)o).getName());
            this.list.remove(o);
            return true;
        }
        return false;
    }

    public T removeByName(String name) {
        if (this.elementByName.containsKey(name)) {
            NamedObject t = (NamedObject)this.elementByName.get(name);
            this.elementByName.remove(name);
            this.list.remove(t);
            return (T)t;
        }
        return null;
    }

    @Override
    public T set(int index, T element) {
        String elementName = element.getName();
        if (this.elementByName.containsKey(elementName)) {
            throw new IllegalArgumentException("Element " + elementName + " already in list");
        }
        this.elementByName.put(elementName, element);
        return (T)((NamedObject)this.list.set(index, element));
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

