/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

public class NameChecker {
    public String checkStyleName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Bad name: %s", name));
        }
        int firstCodePoint = name.codePointAt(0);
        if (!this.isNCNameStartChar(firstCodePoint)) {
            throw new IllegalArgumentException(String.format("Bad first char %c (#x%x) in %s", firstCodePoint, firstCodePoint, name));
        }
        for (int i = 1; i < name.length(); ++i) {
            int codePoint = name.codePointAt(i);
            if (this.isNCNameChar(codePoint)) continue;
            throw new IllegalArgumentException(String.format("Bad char %d: %c (#x%x) in %s", i, codePoint, codePoint, name));
        }
        return name;
    }

    public boolean isNameStartChar(int codePoint) {
        return codePoint == 58 || this.isNCNameStartChar(codePoint);
    }

    public boolean isNameChar(int codePoint) {
        return codePoint == 58 || this.isNCNameChar(codePoint);
    }

    public boolean isNCNameStartChar(int codePoint) {
        return 97 <= codePoint && codePoint <= 122 || 65 <= codePoint && codePoint <= 90 || codePoint == 45 || 192 <= codePoint && codePoint <= 767 && codePoint != 215 && codePoint != 247 || 880 <= codePoint && codePoint <= 8191 && codePoint != 894 || codePoint == 8204 || codePoint == 8205 || 8304 <= codePoint && codePoint <= 8591 || 11264 <= codePoint && codePoint <= 12271 || 12289 <= codePoint && codePoint <= 55295 || 63744 <= codePoint && codePoint <= 64975 || 65008 <= codePoint && codePoint <= 65533 || 65536 <= codePoint && codePoint <= 983039;
    }

    public boolean isNCNameChar(int codePoint) {
        return 48 <= codePoint && codePoint <= 57 || codePoint == 95 || codePoint == 46 || this.isNCNameStartChar(codePoint) || codePoint == 183 || 768 <= codePoint && codePoint <= 879 || 8255 <= codePoint && codePoint <= 8256;
    }
}

