/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyleBuilder;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TableColumnStyle
implements FontFaceContainerStyle {
    public static final TableColumnStyle DEFAULT_TABLE_COLUMN_STYLE = TableColumnStyle.builder("co1").build();
    private static TableColumnStyle defaultColumnStyle;
    private final boolean hidden;
    private final Length columnWidth;
    private final TableCellStyle defaultCellStyle;
    private final String name;
    private final boolean optimalWidth;
    private String key;

    public static TableColumnStyleBuilder builder(String name) {
        return new TableColumnStyleBuilder(name);
    }

    TableColumnStyle(String name, boolean hidden, Length columnWidth, TableCellStyle defaultCellStyle, boolean optimalWidth) {
        this.name = name;
        this.hidden = hidden;
        this.columnWidth = columnWidth;
        this.defaultCellStyle = defaultCellStyle;
        this.optimalWidth = optimalWidth;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addContentStyle(this);
        odsElements.addContentStyle(this.defaultCellStyle);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendEAttribute(appendable, "style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "table-column");
        appendable.append("><style:table-column-properties");
        util.appendAttribute(appendable, (CharSequence)"fo:break-before", "auto");
        if (this.optimalWidth) {
            util.appendAttribute(appendable, (CharSequence)"style:use-optimal-column-width", this.optimalWidth);
        } else if (this.columnWidth.isNotNull()) {
            util.appendAttribute(appendable, (CharSequence)"style:column-width", this.columnWidth.toString());
        }
        appendable.append("/></style:style>");
    }

    public void appendXMLToTable(XMLUtil util, Appendable appendable, int count) throws IOException {
        appendable.append("<table:table-column");
        util.appendEAttribute(appendable, "table:style-name", this.name);
        if (count > 1) {
            util.appendAttribute(appendable, (CharSequence)"table:number-columns-repeated", count);
        }
        if (this.defaultCellStyle != null) {
            util.appendEAttribute(appendable, "table:default-cell-style-name", this.defaultCellStyle.getName());
        }
        appendable.append("/>");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TableColumnStyle) {
            TableColumnStyle other = (TableColumnStyle)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    @Deprecated
    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public TableCellStyle getDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.TABLE_COLUMN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void addToContentStyles(StylesContainer stylesContainer) {
        stylesContainer.addContentStyle(this);
        stylesContainer.addContentStyle(this.defaultCellStyle);
    }

    @Override
    public FontFace getFontFace() {
        return this.defaultCellStyle.getFontFace();
    }
}

