/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.style.BorderAttribute;
import com.github.jferard.fastods.style.Borders;
import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.Length;

public class BordersBuilder {
    private BorderAttribute all;
    private BorderAttribute bottom;
    private BorderAttribute left;
    private BorderAttribute right;
    private BorderAttribute top;

    public BordersBuilder all(BorderAttribute attribute) {
        this.all = attribute;
        return this;
    }

    public BordersBuilder all(Length size, Color color, BorderAttribute.Style style) {
        return this.all(new BorderAttribute(size, color, style));
    }

    public BordersBuilder bottom(BorderAttribute attribute) {
        this.bottom = attribute;
        return this;
    }

    public BordersBuilder bottom(Length size, Color color, BorderAttribute.Style style) {
        return this.bottom(new BorderAttribute(size, color, style));
    }

    public Borders build() {
        return new Borders(new EqualityUtil(), this.all, this.top, this.right, this.bottom, this.left);
    }

    public BordersBuilder left(BorderAttribute attribute) {
        this.left = attribute;
        return this;
    }

    public BordersBuilder left(Length size, Color color, BorderAttribute.Style style) {
        return this.left(new BorderAttribute(size, color, style));
    }

    public BordersBuilder right(BorderAttribute attribute) {
        this.right = attribute;
        return this;
    }

    public BordersBuilder right(Length size, Color color, BorderAttribute.Style style) {
        return this.right(new BorderAttribute(size, color, style));
    }

    public BordersBuilder top(BorderAttribute attribute) {
        this.top = attribute;
        return this;
    }

    public BordersBuilder top(Length size, Color color, BorderAttribute.Style style) {
        return this.top(new BorderAttribute(size, color, style));
    }
}

