/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;

public class PercentageValue
implements CellValue {
    private final double value;

    public static PercentageValue from(Object o) throws FastOdsException {
        if (o instanceof Number) {
            return new PercentageValue(((Number)o).floatValue());
        }
        if (o instanceof PercentageValue) {
            return (PercentageValue)o;
        }
        throw new FastOdsException("Can't cast " + o + " to Percentage");
    }

    public PercentageValue(double value) {
        this.value = value;
    }

    @Override
    public void setToCell(TableCell tableCell) {
        tableCell.setPercentageValue(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PercentageValue)) {
            return false;
        }
        PercentageValue other = (PercentageValue)o;
        return Math.abs(this.value - other.value) < 1.0E-5;
    }

    public final int hashCode() {
        return (int)this.value;
    }
}

