/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.OdsFlusher;
import com.github.jferard.fastods.TableAppender;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.List;

public class EndTableFlusher
implements OdsFlusher {
    private final TableAppender appender;
    private final List<TableRowImpl> rows;

    public EndTableFlusher(TableAppender appender, List<TableRowImpl> rows) {
        this.appender = appender;
        this.rows = rows;
    }

    @Override
    public void flushInto(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        for (TableRowImpl row : this.rows) {
            row.appendXMLToTable(xmlUtil, writer);
        }
        this.appender.appendPostamble(writer);
    }

    @Override
    public boolean isEnd() {
        return false;
    }
}

