/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.io.Serializable;

public interface TimeFunction
extends Serializable {
    public double of(int var1);

    public static TimeFunction constant(double alpha) {
        return t2 -> alpha;
    }

    public static TimeFunction linear(double alpha, double T) {
        return t2 -> alpha * (1.0 - Math.min((double)t2, T - 1.0) / T);
    }

    public static TimeFunction inverse(double alpha, double C) {
        return t2 -> alpha * C / (C + (double)t2);
    }

    public static TimeFunction exp(double alpha, double C) {
        return t2 -> alpha * Math.exp((double)(-t2) / C);
    }
}

