/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.CholeskyDecomposition;
import smile.math.matrix.ColumnMajorMatrix;
import smile.math.matrix.DenseMatrix;

public class QRDecomposition {
    private DenseMatrix QR;
    private double[] Rdiagonal;
    private boolean singular;

    public QRDecomposition(double[][] A) {
        this(new ColumnMajorMatrix(A));
    }

    public QRDecomposition(DenseMatrix A) {
        int m = A.nrows();
        int n = A.ncols();
        this.Rdiagonal = new double[n];
        this.QR = A;
        for (int k = 0; k < n; ++k) {
            int i;
            double nrm = 0.0;
            for (i = k; i < m; ++i) {
                nrm = Math.hypot(nrm, this.QR.get(i, k));
            }
            if (nrm != 0.0) {
                if (this.QR.get(k, k) < 0.0) {
                    nrm = -nrm;
                }
                for (i = k; i < m; ++i) {
                    this.QR.div(i, k, nrm);
                }
                this.QR.add(k, k, 1.0);
                for (int j = k + 1; j < n; ++j) {
                    int i2;
                    double s = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        s += this.QR.get(i2, k) * this.QR.get(i2, j);
                    }
                    s = -s / this.QR.get(k, k);
                    for (i2 = k; i2 < m; ++i2) {
                        this.QR.add(i2, j, s * this.QR.get(i2, k));
                    }
                }
            }
            this.Rdiagonal[k] = -nrm;
        }
        this.singular = false;
        for (int j = 0; j < this.Rdiagonal.length; ++j) {
            if (this.Rdiagonal[j] != 0.0) continue;
            this.singular = true;
            break;
        }
    }

    public boolean isFullColumnRank() {
        return !this.singular;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public DenseMatrix getH() {
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        ColumnMajorMatrix H = new ColumnMajorMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                H.set(i, j, this.QR.get(i, j));
            }
        }
        return H;
    }

    public CholeskyDecomposition toCholesky() {
        int n = this.QR.ncols();
        double[][] L = new double[n][];
        for (int i = 0; i < n; ++i) {
            L[i] = new double[i + 1];
            L[i][i] = this.Rdiagonal[i];
            for (int j = 0; j < i; ++j) {
                L[i][j] = this.QR.get(j, i);
            }
        }
        return CholeskyDecomposition.newInstance(L);
    }

    public DenseMatrix getR() {
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        ColumnMajorMatrix R = new ColumnMajorMatrix(m, n);
        for (int i = 0; i < n; ++i) {
            R.set(i, i, this.Rdiagonal[i]);
            for (int j = i; j < n; ++j) {
                R.set(i, j, this.QR.get(i, j));
            }
        }
        return R;
    }

    public DenseMatrix getQ() {
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        ColumnMajorMatrix Q = new ColumnMajorMatrix(m, n);
        for (int k = n - 1; k >= 0; --k) {
            Q.set(k, k, 1.0);
            for (int j = k; j < n; ++j) {
                int i;
                if (this.QR.get(k, k) == 0.0) continue;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.QR.get(i, k) * Q.get(i, j);
                }
                s = -s / this.QR.get(k, k);
                for (i = k; i < m; ++i) {
                    Q.add(i, j, s * this.QR.get(i, k));
                }
            }
        }
        return Q;
    }

    public DenseMatrix inverse() {
        ColumnMajorMatrix inv = ColumnMajorMatrix.eye(this.QR.ncols(), this.QR.nrows());
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b, double[] x) {
        int k;
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        if (b.length != m) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but b is %d x 1", this.QR.nrows(), this.QR.ncols(), b.length));
        }
        if (x.length != n) {
            throw new IllegalArgumentException("A and x dimensions do not agree.");
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        double[] y = b;
        if (b != x) {
            y = (double[])b.clone();
        }
        for (k = 0; k < n; ++k) {
            int i;
            double s = 0.0;
            for (i = k; i < m; ++i) {
                s += this.QR.get(i, k) * y[i];
            }
            s = -s / this.QR.get(k, k);
            for (i = k; i < m; ++i) {
                int n2 = i;
                y[n2] = y[n2] + s * this.QR.get(i, k);
            }
        }
        for (k = n - 1; k >= 0; --k) {
            x[k] = y[k] / this.Rdiagonal[k];
            for (int i = 0; i < k; ++i) {
                int n3 = i;
                y[n3] = y[n3] - x[k] * this.QR.get(i, k);
            }
        }
    }

    public void solve(DenseMatrix B) {
        if (this.QR.nrows() != this.QR.ncols()) {
            throw new UnsupportedOperationException("In-place solver supports only square matrix.");
        }
        this.solve(B, B);
    }

    public void solve(DenseMatrix B, DenseMatrix X) {
        int k;
        int j;
        if (B.nrows() != this.QR.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.QR.nrows(), this.QR.nrows(), B.nrows(), B.ncols()));
        }
        if (X.nrows() != this.QR.ncols()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but X is %d x %d", this.QR.nrows(), this.QR.nrows(), X.nrows(), X.ncols()));
        }
        if (B.ncols() != X.ncols()) {
            throw new IllegalArgumentException(String.format("B and X column dimension do not agree: B is %d x %d, but X is %d x %d", B.nrows(), B.ncols(), X.nrows(), X.ncols()));
        }
        if (!this.isFullColumnRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        if (X.ncols() != B.ncols()) {
            throw new IllegalArgumentException("B and X dimensions do not agree.");
        }
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        int nx = B.ncols();
        if (B != X) {
            for (int i = 0; i < n; ++i) {
                for (j = 0; j < nx; ++j) {
                    X.set(i, j, B.get(i, j));
                }
            }
        }
        for (k = 0; k < n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < m; ++i) {
                    s += this.QR.get(i, k) * X.get(i, j);
                }
                s = -s / this.QR.get(k, k);
                for (i = k; i < m; ++i) {
                    X.add(i, j, s * this.QR.get(i, k));
                }
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                X.set(k, j, X.get(k, j) / this.Rdiagonal[k]);
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    X.sub(i, j2, X.get(k, j2) * this.QR.get(i, k));
                }
            }
        }
    }

    public void update(double[] u, double[] v) {
        int i;
        int k;
        int m = this.QR.nrows();
        int n = this.QR.ncols();
        if (u.length != m || v.length != n) {
            throw new IllegalArgumentException("u.length = " + u.length + " v.length = " + v.length);
        }
        for (k = m - 1; k >= 0 && u[k] == 0.0; --k) {
        }
        if (k < 0) {
            return;
        }
        for (i = k - 1; i >= 0; --i) {
            this.rotate(i, u[i], -u[i + 1]);
            u[i] = u[i] == 0.0 ? Math.abs(u[i + 1]) : (Math.abs(u[i]) > Math.abs(u[i + 1]) ? Math.abs(u[i]) * Math.sqrt(1.0 + Math.sqr(u[i + 1] / u[i])) : Math.abs(u[i + 1]) * Math.sqrt(1.0 + Math.sqr(u[i] / u[i + 1])));
        }
        this.Rdiagonal[0] = this.Rdiagonal[0] + u[0] * v[0];
        for (i = 1; i < n; ++i) {
            this.QR.add(0, i, u[0] * v[i]);
        }
        for (i = 0; i < k; ++i) {
            this.rotate(i, this.Rdiagonal[i], -this.QR.get(i + 1, i));
        }
        for (i = 0; i < n; ++i) {
            if (this.Rdiagonal[i] != 0.0) continue;
            this.singular = true;
        }
    }

    private void rotate(int i, double a, double b) {
        double w;
        double y;
        int j;
        double fact;
        double s;
        double c;
        int n = this.QR.ncols();
        if (a == 0.0) {
            c = 0.0;
            s = b >= 0.0 ? 1.0 : -1.0;
        } else if (Math.abs(a) > Math.abs(b)) {
            fact = b / a;
            c = Math.copySign(1.0 / Math.sqrt(1.0 + fact * fact), a);
            s = fact * c;
        } else {
            fact = a / b;
            s = Math.copySign(1.0 / Math.sqrt(1.0 + fact * fact), b);
            c = fact * s;
        }
        for (j = i; j < n; ++j) {
            y = i == j ? this.Rdiagonal[i] : this.QR.get(i, j);
            w = this.QR.get(i + 1, j);
            this.QR.set(i, j, c * y - s * w);
            this.QR.set(i + 1, j, s * y + c * w);
        }
        for (j = 0; j < n; ++j) {
            y = this.QR.get(i, j);
            w = this.QR.get(i + 1, j);
            this.QR.set(i, j, c * y - s * w);
            this.QR.set(i + 1, j, s * y + c * w);
        }
    }
}

