/*
 * Decompiled with CFR 0.152.
 */
package smile.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import smile.graph.Graph;
import smile.graph.Visitor;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.util.PriorityQueue;

public class AdjacencyMatrix
implements Graph {
    private int n;
    private boolean digraph;
    private double[][] graph;

    public AdjacencyMatrix(int n) {
        this(n, false);
    }

    public AdjacencyMatrix(int n, boolean digraph) {
        this.n = n;
        this.digraph = digraph;
        this.graph = new double[n][n];
    }

    @Override
    public int getNumVertices() {
        return this.n;
    }

    @Override
    public boolean hasEdge(int source, int target) {
        return this.graph[source][target] != 0.0;
    }

    @Override
    public double getWeight(int source, int target) {
        return this.graph[source][target];
    }

    @Override
    public AdjacencyMatrix setWeight(int source, int target, double weight) {
        this.graph[source][target] = weight;
        if (!this.digraph) {
            this.graph[target][source] = weight;
        }
        return this;
    }

    @Override
    public Collection<Graph.Edge> getEdges() {
        LinkedList<Graph.Edge> set = new LinkedList<Graph.Edge>();
        if (this.digraph) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    if (this.graph[i][j] == 0.0) continue;
                    Graph.Edge edge = new Graph.Edge(i, j, this.graph[i][j]);
                    set.add(edge);
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = i; j < this.n; ++j) {
                    if (this.graph[i][j] == 0.0) continue;
                    Graph.Edge edge = new Graph.Edge(i, j, this.graph[i][j]);
                    set.add(edge);
                }
            }
        }
        return set;
    }

    @Override
    public Collection<Graph.Edge> getEdges(int vertex) {
        LinkedList<Graph.Edge> set = new LinkedList<Graph.Edge>();
        for (int j = 0; j < this.n; ++j) {
            if (this.graph[vertex][j] == 0.0) continue;
            Graph.Edge edge = new Graph.Edge(vertex, j, this.graph[vertex][j]);
            set.add(edge);
        }
        return set;
    }

    @Override
    public Collection<Graph.Edge> getEdges(int source, int target) {
        LinkedList<Graph.Edge> set = new LinkedList<Graph.Edge>();
        Graph.Edge edge = this.getEdge(source, target);
        if (edge != null) {
            set.add(edge);
        }
        return set;
    }

    @Override
    public Graph.Edge getEdge(int source, int target) {
        if (this.graph[source][target] == 0.0) {
            return null;
        }
        return new Graph.Edge(source, target, this.graph[source][target]);
    }

    @Override
    public void addEdge(int source, int target) {
        if (this.digraph) {
            if (this.graph[source][target] == 0.0) {
                this.graph[source][target] = 1.0;
            }
        } else if (this.graph[source][target] == 0.0) {
            this.graph[source][target] = 1.0;
            this.graph[target][source] = 1.0;
        }
    }

    @Override
    public void addEdge(int source, int target, double weight) {
        if (this.digraph) {
            this.graph[source][target] = weight;
        } else {
            this.graph[source][target] = weight;
            this.graph[target][source] = weight;
        }
    }

    @Override
    public void removeEdges(Collection<Graph.Edge> edges) {
        Iterator<Graph.Edge> iter = edges.iterator();
        while (iter.hasNext()) {
            this.removeEdge(iter.next());
        }
    }

    @Override
    public void removeEdge(int source, int target) {
        if (this.digraph) {
            this.graph[source][target] = 0.0;
        } else {
            this.graph[source][target] = 0.0;
            this.graph[target][source] = 0.0;
        }
    }

    @Override
    public void removeEdge(Graph.Edge edge) {
        this.removeEdge(edge.v1, edge.v2);
    }

    @Override
    public int getDegree(int vertex) {
        if (this.digraph) {
            return this.getIndegree(vertex) + this.getOutdegree(vertex);
        }
        return this.getOutdegree(vertex);
    }

    @Override
    public int getIndegree(int vertex) {
        int degree = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.graph[i][vertex] == 0.0) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public int getOutdegree(int vertex) {
        int degree = 0;
        for (int j = 0; j < this.n; ++j) {
            if (this.graph[vertex][j] == 0.0) continue;
            ++degree;
        }
        return degree;
    }

    private int dfsearch(int v, int[] pre, int[] ts, int count) {
        pre[v] = 0;
        for (int t = 0; t < this.n; ++t) {
            if (this.graph[v][t] == 0.0 || pre[t] != -1) continue;
            count = this.dfsearch(t, pre, ts, count);
        }
        ts[count++] = v;
        return count;
    }

    @Override
    public int[] sortdfs() {
        int i;
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort is only meaningful for digraph.");
        }
        int count = 0;
        int[] pre = new int[this.n];
        int[] ts = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            pre[i] = -1;
            ts[i] = -1;
        }
        for (i = 0; i < this.n; ++i) {
            if (pre[i] != -1) continue;
            count = this.dfsearch(i, pre, ts, count);
        }
        return ts;
    }

    private void dfs(int v, int[] cc, int id) {
        cc[v] = id;
        for (int t = 0; t < this.n; ++t) {
            if (this.graph[v][t] == 0.0 || cc[t] != -1) continue;
            this.dfs(t, cc, id);
        }
    }

    @Override
    public int[][] dfs() {
        int[] cc = new int[this.n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < this.n; ++i) {
            if (cc[i] != -1) continue;
            this.dfs(i, cc, id++);
        }
        int[] size = new int[id];
        for (int i = 0; i < this.n; ++i) {
            int n = cc[i];
            size[n] = size[n] + 1;
        }
        int[][] components = new int[id][];
        for (int i = 0; i < id; ++i) {
            components[i] = new int[size[i]];
            int k = 0;
            for (int j = 0; j < this.n; ++j) {
                if (cc[j] != i) continue;
                components[i][k++] = j;
            }
            Arrays.sort(components[i]);
        }
        return components;
    }

    private void dfs(Visitor visitor, int v, int[] cc, int id) {
        visitor.visit(v);
        cc[v] = id;
        for (int t = 0; t < this.n; ++t) {
            if (this.graph[v][t] == 0.0 || cc[t] != -1) continue;
            this.dfs(visitor, t, cc, id);
        }
    }

    @Override
    public void dfs(Visitor visitor) {
        int[] cc = new int[this.n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < this.n; ++i) {
            if (cc[i] != -1) continue;
            this.dfs(visitor, i, cc, id++);
        }
    }

    @Override
    public int[] sortbfs() {
        int i;
        if (!this.digraph) {
            throw new UnsupportedOperationException("Topological sort is only meaningful for digraph.");
        }
        int[] in = new int[this.n];
        int[] ts = new int[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            ts[i2] = -1;
            for (int v = 0; v < this.n; ++v) {
                if (this.graph[i2][v] == 0.0) continue;
                int n = v;
                in[n] = in[n] + 1;
            }
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i = 0; i < this.n; ++i) {
            if (in[i] != 0) continue;
            queue.offer(i);
        }
        i = 0;
        while (!queue.isEmpty()) {
            int t;
            ts[i] = t = ((Integer)queue.poll()).intValue();
            for (int v = 0; v < this.n; ++v) {
                if (this.graph[t][v] == 0.0) continue;
                int n = v;
                in[n] = in[n] - 1;
                if (in[n] != 0) continue;
                queue.offer(v);
            }
            ++i;
        }
        return ts;
    }

    private void bfs(int v, int[] cc, int id) {
        cc[v] = id;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(v);
        while (!queue.isEmpty()) {
            int t = (Integer)queue.poll();
            for (int i = 0; i < this.n; ++i) {
                if (this.graph[t][i] == 0.0 || cc[i] != -1) continue;
                queue.offer(i);
                cc[i] = id;
            }
        }
    }

    @Override
    public int[][] bfs() {
        int[] cc = new int[this.n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < this.n; ++i) {
            if (cc[i] != -1) continue;
            this.bfs(i, cc, id++);
        }
        int[] size = new int[id];
        for (int i = 0; i < this.n; ++i) {
            int n = cc[i];
            size[n] = size[n] + 1;
        }
        int[][] components = new int[id][];
        for (int i = 0; i < id; ++i) {
            components[i] = new int[size[i]];
            int k = 0;
            for (int j = 0; j < this.n; ++j) {
                if (cc[j] != i) continue;
                components[i][k++] = j;
            }
            Arrays.sort(components[i]);
        }
        return components;
    }

    private void bfs(Visitor visitor, int v, int[] cc, int id) {
        visitor.visit(v);
        cc[v] = id;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(v);
        while (!queue.isEmpty()) {
            int t = (Integer)queue.poll();
            for (int i = 0; i < this.n; ++i) {
                if (this.graph[t][i] == 0.0 || cc[i] != -1) continue;
                visitor.visit(i);
                queue.offer(i);
                cc[i] = id;
            }
        }
    }

    @Override
    public void bfs(Visitor visitor) {
        int[] cc = new int[this.n];
        Arrays.fill(cc, -1);
        int id = 0;
        for (int i = 0; i < this.n; ++i) {
            if (cc[i] != -1) continue;
            this.bfs(visitor, i, cc, id++);
        }
    }

    @Override
    public double[] dijkstra(int s) {
        return this.dijkstra(s, true);
    }

    public double[] dijkstra(int s, boolean weighted) {
        int v;
        double[] wt = new double[this.n];
        Arrays.fill(wt, Double.POSITIVE_INFINITY);
        PriorityQueue queue = new PriorityQueue(wt);
        for (v = 0; v < this.n; ++v) {
            queue.insert(v);
        }
        wt[s] = 0.0;
        queue.lower(s);
        while (!queue.empty()) {
            v = queue.poll();
            if (Double.isInfinite(wt[v])) continue;
            for (int w = 0; w < this.n; ++w) {
                double p;
                if (this.graph[v][w] == 0.0) continue;
                double d = p = weighted ? wt[v] + this.graph[v][w] : wt[v] + 1.0;
                if (!(p < wt[w])) continue;
                wt[w] = p;
                queue.lower(w);
            }
        }
        return wt;
    }

    @Override
    public AdjacencyMatrix subgraph(int[] vertices) {
        int[] v = (int[])vertices.clone();
        Arrays.sort(v);
        AdjacencyMatrix g = new AdjacencyMatrix(v.length);
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                g.graph[i][j] = this.graph[v[i]][v[j]];
            }
        }
        return g;
    }

    public double[][] toArray() {
        return MathEx.clone((double[][])this.graph);
    }

    private void push(double[][] flow, double[] excess, int u, int v) {
        double send = Math.min(excess[u], this.graph[u][v] - flow[u][v]);
        double[] dArray = flow[u];
        int n = v;
        dArray[n] = dArray[n] + send;
        double[] dArray2 = flow[v];
        int n2 = u;
        dArray2[n2] = dArray2[n2] - send;
        int n3 = u;
        excess[n3] = excess[n3] - send;
        int n4 = v;
        excess[n4] = excess[n4] + send;
    }

    private void relabel(double[][] flow, int[] height, int u) {
        int minHeight = 2 * this.n;
        for (int v = 0; v < this.n; ++v) {
            if (!(this.graph[u][v] - flow[u][v] > 0.0)) continue;
            minHeight = Math.min(minHeight, height[v]);
            height[u] = minHeight + 1;
        }
    }

    private void discharge(double[][] flow, double[] excess, int[] height, int[] seen, int u) {
        while (excess[u] > 0.0) {
            if (seen[u] < this.n) {
                int v = seen[u];
                if (this.graph[u][v] - flow[u][v] > 0.0 && height[u] > height[v]) {
                    this.push(flow, excess, u, v);
                    continue;
                }
                int n = u;
                seen[n] = seen[n] + 1;
                continue;
            }
            this.relabel(flow, height, u);
            seen[u] = 0;
        }
    }

    private static void moveToFront(int i, int[] array) {
        int temp = array[i];
        for (int j = i; j > 0; --j) {
            array[j] = array[j - 1];
        }
        array[0] = temp;
    }

    public double pushRelabel(double[][] flow, int source, int sink) {
        int[] seen = new int[this.n];
        int[] queue = new int[this.n - 2];
        int p = 0;
        for (int i = 0; i < this.n; ++i) {
            if (i == source || i == sink) continue;
            queue[p++] = i;
        }
        int[] height = new int[this.n];
        height[source] = this.n;
        double[] excess = new double[this.n];
        excess[source] = Double.MAX_VALUE;
        for (int i = 0; i < this.n; ++i) {
            this.push(flow, excess, source, i);
        }
        int p2 = 0;
        while (p2 < this.n - 2) {
            int u = queue[p2];
            double oldHeight = height[u];
            this.discharge(flow, excess, height, seen, u);
            if ((double)height[u] > oldHeight) {
                AdjacencyMatrix.moveToFront(p2, queue);
                p2 = 0;
                continue;
            }
            ++p2;
        }
        double maxflow = 0.0;
        for (int i = 0; i < this.n; ++i) {
            maxflow += flow[source][i];
        }
        return maxflow;
    }

    @Override
    public Matrix toMatrix() {
        return Matrix.of((double[][])this.graph);
    }
}

