/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.regex.Pattern;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.util.Strings;

public interface DataType
extends Serializable {
    public static final Pattern BooleanPattern = Pattern.compile("(true|false)", 2);
    public static final Pattern IntPattern = Pattern.compile("[-+]?\\d{1,9}");
    public static final Pattern LongPattern = Pattern.compile("[-+]?\\d{1,19}");
    public static final Pattern DoublePattern = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");
    public static final Pattern DatePattern = Pattern.compile("\\d{4}(-|\\/)((0[1-9])|(1[0-2]))(-|\\/)((0[1-9])|([1-2][0-9])|(3[0-1]))");
    public static final Pattern TimePattern = Pattern.compile("(([0-1][0-9])|(2[0-3])):([0-5][0-9])(:([0-5][0-9]))?");
    public static final Pattern DateTimePattern = Pattern.compile("\\d{4}(-|\\/)((0[1-9])|(1[0-2]))(-|\\/)((0[1-9])|([1-2][0-9])|(3[0-1]))(T|\\s)(([0-1][0-9])|(2[0-3])):([0-5][0-9]):([0-5][0-9])");

    public String name();

    public ID id();

    public Object valueOf(String var1);

    default public String toString(Object o) {
        return o == null ? "null" : o.toString();
    }

    default public boolean isPrimitive() {
        switch (this.id()) {
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Char: 
            case Byte: 
            case Short: {
                return true;
            }
        }
        return false;
    }

    default public boolean isFloating() {
        return this.isFloat() || this.isDouble();
    }

    default public boolean isIntegral() {
        return this.isInt() || this.isLong() || this.isShort() || this.isByte();
    }

    default public boolean isNumeric() {
        return this.isFloating() || this.isIntegral();
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isChar() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isObject() {
        return false;
    }

    default public DataType boxed() {
        switch (this.id()) {
            case Boolean: {
                return DataTypes.BooleanObjectType;
            }
            case Char: {
                return DataTypes.CharObjectType;
            }
            case Byte: {
                return DataTypes.ByteObjectType;
            }
            case Short: {
                return DataTypes.ShortObjectType;
            }
            case Integer: {
                return DataTypes.IntegerObjectType;
            }
            case Long: {
                return DataTypes.LongObjectType;
            }
            case Float: {
                return DataTypes.FloatObjectType;
            }
            case Double: {
                return DataTypes.DoubleObjectType;
            }
        }
        return this;
    }

    default public DataType unboxed() {
        if (this.isObject()) {
            if (this.isBoolean()) {
                return DataTypes.BooleanType;
            }
            if (this.isChar()) {
                return DataTypes.CharType;
            }
            if (this.isByte()) {
                return DataTypes.ByteType;
            }
            if (this.isShort()) {
                return DataTypes.ShortType;
            }
            if (this.isInt()) {
                return DataTypes.IntegerType;
            }
            if (this.isLong()) {
                return DataTypes.LongType;
            }
            if (this.isFloat()) {
                return DataTypes.FloatType;
            }
            if (this.isDouble()) {
                return DataTypes.DoubleType;
            }
        }
        return this;
    }

    public static DataType infer(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        if (DateTimePattern.matcher(s).matches()) {
            return DataTypes.DateTimeType;
        }
        if (DatePattern.matcher(s).matches()) {
            return DataTypes.DateType;
        }
        if (TimePattern.matcher(s).matches()) {
            return DataTypes.TimeType;
        }
        if (IntPattern.matcher(s).matches()) {
            return DataTypes.IntegerType;
        }
        if (LongPattern.matcher(s).matches()) {
            return DataTypes.LongType;
        }
        if (DoublePattern.matcher(s).matches()) {
            return DataTypes.DoubleType;
        }
        if (BooleanPattern.matcher(s).matches()) {
            return DataTypes.BooleanType;
        }
        return DataTypes.StringType;
    }

    public static DataType of(String s) throws ClassNotFoundException {
        switch (s) {
            case "boolean": {
                return DataTypes.BooleanType;
            }
            case "char": {
                return DataTypes.CharType;
            }
            case "byte": {
                return DataTypes.ByteType;
            }
            case "short": {
                return DataTypes.ShortType;
            }
            case "int": {
                return DataTypes.IntegerType;
            }
            case "long": {
                return DataTypes.LongType;
            }
            case "float": {
                return DataTypes.FloatType;
            }
            case "double": {
                return DataTypes.DoubleType;
            }
            case "Decimal": {
                return DataTypes.DecimalType;
            }
            case "String": {
                return DataTypes.StringType;
            }
            case "Date": {
                return DataTypes.DateType;
            }
            case "DateTime": {
                return DataTypes.DateTimeType;
            }
            case "Time": {
                return DataTypes.TimeType;
            }
        }
        if (s.startsWith("Date[") && s.endsWith("]")) {
            return DataTypes.date(s.substring(5, s.length() - 1));
        }
        if (s.startsWith("DateTime[") && s.endsWith("]")) {
            return DataTypes.datetime(s.substring(9, s.length() - 1));
        }
        if (s.startsWith("Time[") && s.endsWith("]")) {
            return DataTypes.datetime(s.substring(5, s.length() - 1));
        }
        if (s.startsWith("Object[") && s.endsWith("]")) {
            return DataTypes.object(Class.forName(s.substring(7, s.length() - 1)));
        }
        if (s.startsWith("Array[") && s.endsWith("]")) {
            return DataTypes.array(DataType.of(s.substring(6, s.length() - 1).trim()));
        }
        if (s.startsWith("Struct[") && s.endsWith("]")) {
            String[] elements = s.substring(7, s.length() - 1).split(",");
            StructField[] fields = new StructField[elements.length];
            for (int i = 0; i < fields.length; ++i) {
                String[] item = elements[i].split(":");
                fields[i] = new StructField(item[0].trim(), DataType.of(item[1].trim()));
            }
            return DataTypes.struct(fields);
        }
        throw new IllegalArgumentException(String.format("Unknown data type: %s", s));
    }

    public static DataType of(Class clazz) {
        if (clazz == Integer.TYPE) {
            return DataTypes.IntegerType;
        }
        if (clazz == Double.TYPE) {
            return DataTypes.DoubleType;
        }
        if (clazz == Long.TYPE) {
            return DataTypes.LongType;
        }
        if (clazz == Float.TYPE) {
            return DataTypes.FloatType;
        }
        if (clazz == Boolean.TYPE) {
            return DataTypes.BooleanType;
        }
        if (clazz == Short.TYPE) {
            return DataTypes.ShortType;
        }
        if (clazz == Byte.TYPE) {
            return DataTypes.ByteType;
        }
        if (clazz == Character.TYPE) {
            return DataTypes.CharType;
        }
        if (clazz == Integer.class) {
            return DataTypes.IntegerObjectType;
        }
        if (clazz == Double.class) {
            return DataTypes.DoubleObjectType;
        }
        if (clazz == Long.class) {
            return DataTypes.LongObjectType;
        }
        if (clazz == Float.class) {
            return DataTypes.FloatObjectType;
        }
        if (clazz == Boolean.class) {
            return DataTypes.BooleanObjectType;
        }
        if (clazz == Short.class) {
            return DataTypes.ShortObjectType;
        }
        if (clazz == Byte.class) {
            return DataTypes.ByteObjectType;
        }
        if (clazz == Character.class) {
            return DataTypes.CharObjectType;
        }
        if (clazz == String.class) {
            return DataTypes.StringType;
        }
        if (clazz == BigDecimal.class) {
            return DataTypes.DecimalType;
        }
        if (clazz == LocalDate.class) {
            return DataTypes.DateType;
        }
        if (clazz == LocalDateTime.class) {
            return DataTypes.DateTimeType;
        }
        if (clazz == LocalTime.class) {
            return DataTypes.TimeType;
        }
        if (clazz.isArray()) {
            return DataTypes.array(DataType.of(clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            int levels = clazz.getEnumConstants().length;
            if (levels < 128) {
                return DataTypes.ByteType;
            }
            if (levels < 32768) {
                return DataTypes.ShortType;
            }
            return DataTypes.IntegerType;
        }
        return DataTypes.object(clazz);
    }

    public static DataType of(JDBCType type, boolean nullable, String dbms) {
        switch (type) {
            case BOOLEAN: 
            case BIT: {
                return nullable ? DataTypes.BooleanObjectType : DataTypes.BooleanType;
            }
            case TINYINT: {
                return nullable ? DataTypes.ByteObjectType : DataTypes.ByteType;
            }
            case SMALLINT: {
                return nullable ? DataTypes.ShortObjectType : DataTypes.ShortType;
            }
            case INTEGER: {
                return nullable ? DataTypes.IntegerObjectType : DataTypes.IntegerType;
            }
            case BIGINT: {
                return nullable ? DataTypes.LongObjectType : DataTypes.LongType;
            }
            case NUMERIC: {
                if ("SQLite".equals(dbms)) {
                    return nullable ? DataTypes.DoubleObjectType : DataTypes.DoubleType;
                }
                return DataTypes.DecimalType;
            }
            case DECIMAL: {
                return DataTypes.DecimalType;
            }
            case REAL: 
            case FLOAT: {
                return nullable ? DataTypes.FloatObjectType : DataTypes.FloatType;
            }
            case DOUBLE: {
                return nullable ? DataTypes.DoubleObjectType : DataTypes.DoubleType;
            }
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case LONGNVARCHAR: 
            case CLOB: {
                return DataTypes.StringType;
            }
            case DATE: {
                return DataTypes.DateType;
            }
            case TIME: {
                return DataTypes.TimeType;
            }
            case TIMESTAMP: {
                return DataTypes.DateTimeType;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: 
            case BLOB: {
                return DataTypes.ByteArrayType;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported JDBCType: %s", type));
    }

    public static DataType prompt(DataType a, DataType b) {
        if (!(a.isInt() || a.isLong() || a.isFloat() || a.isDouble())) {
            throw new IllegalArgumentException(String.format("Invalid data type for type promotion: %s", a));
        }
        if (!(b.isInt() || b.isLong() || b.isFloat() || b.isDouble())) {
            throw new IllegalArgumentException(String.format("Invalid data type for type promotion: %s", b));
        }
        if (a.isDouble() || b.isDouble()) {
            if (a.isObject() || b.isObject()) {
                return DataTypes.DoubleObjectType;
            }
            return DataTypes.DoubleType;
        }
        if (a.isFloat() || b.isFloat()) {
            if (a.isObject() || b.isObject()) {
                return DataTypes.FloatObjectType;
            }
            return DataTypes.FloatType;
        }
        if (a.isLong() || b.isLong()) {
            if (a.isObject() || b.isObject()) {
                return DataTypes.LongObjectType;
            }
            return DataTypes.LongType;
        }
        if (a.isObject() || b.isObject()) {
            return DataTypes.IntegerObjectType;
        }
        return DataTypes.IntegerType;
    }

    public static DataType coerce(DataType a, DataType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.id() == b.id()) {
            return a;
        }
        if (a.id() == ID.Integer && b.id() == ID.Double || b.id() == ID.Integer && a.id() == ID.Double) {
            return DataTypes.DoubleType;
        }
        if (a.id() == ID.Date && b.id() == ID.DateTime || b.id() == ID.Date && a.id() == ID.DateTime) {
            return DataTypes.DateTimeType;
        }
        return DataTypes.StringType;
    }

    public static boolean isInt(DataType t) {
        switch (t.id()) {
            case Integer: 
            case Byte: 
            case Short: {
                return true;
            }
            case Object: {
                Class clazz = ((ObjectType)t).getObjectClass();
                return clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
            }
        }
        return false;
    }

    public static boolean isLong(DataType t) {
        return t.id() == ID.Long || t.id() == ID.Object && ((ObjectType)t).getObjectClass() == Long.class;
    }

    public static boolean isFloat(DataType t) {
        return t.id() == ID.Float || t.id() == ID.Object && ((ObjectType)t).getObjectClass() == Float.class;
    }

    public static boolean isDouble(DataType t) {
        return t.id() == ID.Double || t.id() == ID.Object && ((ObjectType)t).getObjectClass() == Double.class;
    }

    public static enum ID {
        Boolean,
        Byte,
        Char,
        Short,
        Integer,
        Long,
        Float,
        Double,
        Decimal,
        String,
        Date,
        Time,
        DateTime,
        Object,
        Array,
        Struct;

    }
}

