/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.ShortVectorImpl;

public interface ShortVector
extends BaseVector<Short, Integer, IntStream> {
    @Override
    default public DataType type() {
        return DataTypes.ShortType;
    }

    public short[] array();

    @Override
    default public byte getByte(int i) {
        throw new UnsupportedOperationException("cast short to byte");
    }

    @Override
    default public int getInt(int i) {
        return this.getShort(i);
    }

    @Override
    default public long getLong(int i) {
        return this.getShort(i);
    }

    @Override
    default public float getFloat(int i) {
        return this.getShort(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getShort(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((IntStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static ShortVector of(String name, short[] vector) {
        return new ShortVectorImpl(name, vector);
    }

    public static ShortVector of(StructField field, short[] vector) {
        return new ShortVectorImpl(field, vector);
    }
}

