/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.LongStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.LongVectorImpl;

public interface LongVector
extends BaseVector<Long, Long, LongStream> {
    @Override
    default public DataType type() {
        return DataTypes.LongType;
    }

    public long[] array();

    @Override
    default public byte getByte(int i) {
        throw new UnsupportedOperationException("cast long to byte");
    }

    @Override
    default public short getShort(int i) {
        throw new UnsupportedOperationException("cast long to short");
    }

    @Override
    default public int getInt(int i) {
        throw new UnsupportedOperationException("cast long to int");
    }

    @Override
    default public float getFloat(int i) {
        return this.getLong(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getLong(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((LongStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static LongVector of(String name, long[] vector) {
        return new LongVectorImpl(name, vector);
    }

    public static LongVector of(String name, LongStream stream) {
        return new LongVectorImpl(name, stream.toArray());
    }

    public static LongVector of(StructField field, long[] vector) {
        return new LongVectorImpl(field, vector);
    }

    public static LongVector of(StructField field, LongStream stream) {
        return new LongVectorImpl(field, stream.toArray());
    }
}

