/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.DoubleVectorImpl;

public interface DoubleVector
extends BaseVector<Double, Double, DoubleStream> {
    @Override
    default public DataType type() {
        return DataTypes.DoubleType;
    }

    public double[] array();

    @Override
    default public byte getByte(int i) {
        throw new UnsupportedOperationException("cast double to byte");
    }

    @Override
    default public short getShort(int i) {
        throw new UnsupportedOperationException("cast double to short");
    }

    @Override
    default public int getInt(int i) {
        throw new UnsupportedOperationException("cast double to int");
    }

    @Override
    default public long getLong(int i) {
        throw new UnsupportedOperationException("cast double to long");
    }

    @Override
    default public float getFloat(int i) {
        throw new UnsupportedOperationException("cast double to float");
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((DoubleStream)this.stream()).limit(n).mapToObj(this.field()::toString).collect(Collectors.joining(", ", "[", suffix));
    }

    public static DoubleVector of(String name, double[] vector) {
        return new DoubleVectorImpl(name, vector);
    }

    public static DoubleVector of(String name, DoubleStream stream) {
        return new DoubleVectorImpl(name, stream.toArray());
    }

    public static DoubleVector of(StructField field, double[] vector) {
        return new DoubleVectorImpl(field, vector);
    }

    public static DoubleVector of(StructField field, DoubleStream stream) {
        return new DoubleVectorImpl(field, stream.toArray());
    }
}

