/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Optional;
import java.util.stream.IntStream;
import smile.data.measure.ContinuousMeasure;
import smile.data.measure.Measure;
import smile.data.type.StructField;
import smile.data.vector.ShortVector;

class ShortVectorImpl
implements ShortVector {
    private String name;
    private Measure measure;
    private short[] vector;

    public ShortVectorImpl(String name, short[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public ShortVectorImpl(StructField field, short[] vector) {
        if (field.measure instanceof ContinuousMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<Measure> measure() {
        return Optional.ofNullable(this.measure);
    }

    @Override
    public short[] array() {
        return this.vector;
    }

    @Override
    public int[] toIntArray(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public short getShort(int i) {
        return this.vector[i];
    }

    @Override
    public Short get(int i) {
        return this.vector[i];
    }

    public ShortVector get(int ... index) {
        short[] v = new short[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new ShortVectorImpl(this.name, v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntStream stream() {
        return IntStream.range(0, this.vector.length).map(i -> this.vector[i]);
    }

    public String toString() {
        return this.toString(10);
    }
}

