/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.formula.HyperTerm;
import smile.data.formula.OneHot;
import smile.data.formula.OneHotEncoder;
import smile.data.formula.OneHotEncoderInteraction;
import smile.data.formula.Term;
import smile.data.type.StructType;

class FactorInteraction
implements HyperTerm {
    private List<String> factors;
    private List<OneHotEncoderInteraction> terms;

    public FactorInteraction(String ... factors) {
        if (factors.length < 2) {
            throw new IllegalArgumentException("Interaction() takes at least two factors");
        }
        this.factors = Arrays.asList(factors);
    }

    public String toString() {
        return this.factors.stream().collect(Collectors.joining(":"));
    }

    @Override
    public List<? extends Term> terms() {
        return this.terms;
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(this.factors);
    }

    @Override
    public void bind(StructType schema) {
        ArrayList encoders = new ArrayList();
        OneHot factor = new OneHot(this.factors.get(this.factors.size() - 1));
        factor.bind(schema);
        encoders.addAll(factor.terms().stream().map(term -> Collections.singletonList(term)).collect(Collectors.toList()));
        for (int i = this.factors.size() - 2; i >= 0; --i) {
            factor = new OneHot(this.factors.get(i));
            factor.bind(schema);
            List<OneHotEncoder> terms = factor.terms();
            encoders.addAll(encoders.stream().flatMap(list -> terms.stream().map(term -> {
                ArrayList<OneHotEncoder> newList = new ArrayList<OneHotEncoder>();
                newList.add((OneHotEncoder)term);
                newList.addAll((Collection<OneHotEncoder>)list);
                return newList;
            })).collect(Collectors.toList()));
            encoders.addAll(terms.stream().map(term -> Collections.singletonList(term)).collect(Collectors.toList()));
        }
        this.terms = encoders.stream().filter(list -> list.size() == this.factors.size()).map(list -> new OneHotEncoderInteraction((List<OneHotEncoder>)list)).collect(Collectors.toList());
    }
}

