/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import smile.data.formula.HyperTerm;
import smile.data.formula.OneHot;
import smile.data.formula.OneHotEncoder;
import smile.data.formula.OneHotEncoderInteraction;
import smile.data.formula.Term;
import smile.data.formula.Variable;
import smile.data.type.StructType;

class FactorCrossing
implements HyperTerm {
    private int order;
    private List<String> factors;
    private List<Term> terms;

    @SafeVarargs
    public FactorCrossing(String ... factors) {
        this(factors.length, factors);
    }

    @SafeVarargs
    public FactorCrossing(int order, String ... factors) {
        if (factors.length < 2) {
            throw new IllegalArgumentException("Cross constructor takes at least two factors");
        }
        if (order < 2 || order > factors.length) {
            throw new IllegalArgumentException("Invalid order of interactions: " + order);
        }
        this.order = order;
        this.factors = Arrays.asList(factors);
    }

    public String toString() {
        if (this.order < this.factors.size()) {
            return this.factors.stream().collect(Collectors.joining(" x ", "(", ")^" + this.order));
        }
        return this.factors.stream().collect(Collectors.joining(" x ", "(", ")"));
    }

    @Override
    public List<? extends Term> terms() {
        return this.terms;
    }

    @Override
    public Set<String> variables() {
        return new HashSet<String>(this.factors);
    }

    @Override
    public void bind(StructType schema) {
        int i;
        ArrayList encoders = new ArrayList();
        OneHot factor = new OneHot(this.factors.get(this.factors.size() - 1));
        factor.bind(schema);
        encoders.addAll(factor.terms().stream().map(term -> Collections.singletonList(term)).collect(Collectors.toList()));
        for (i = this.factors.size() - 2; i >= 0; --i) {
            factor = new OneHot(this.factors.get(i));
            factor.bind(schema);
            List<OneHotEncoder> terms = factor.terms();
            encoders.addAll(encoders.stream().flatMap(list -> terms.stream().map(term -> {
                ArrayList<OneHotEncoder> newList = new ArrayList<OneHotEncoder>();
                newList.add((OneHotEncoder)term);
                newList.addAll((Collection<OneHotEncoder>)list);
                return newList;
            })).collect(Collectors.toList()));
            encoders.addAll(terms.stream().map(term -> Collections.singletonList(term)).collect(Collectors.toList()));
        }
        this.terms = this.factors.stream().map(name -> {
            Variable column = new Variable((String)name);
            column.bind(schema);
            return column;
        }).collect(Collectors.toList());
        i = 2;
        while (i <= this.order) {
            int size = i++;
            this.terms.addAll(encoders.stream().filter(list -> list.size() == size).map(list -> new OneHotEncoderInteraction((List<OneHotEncoder>)list)).collect(Collectors.toList()));
        }
    }
}

