/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructType;

class Abs
extends AbstractFunction {
    public Abs(Term x) {
        super("abs", x);
    }

    @Override
    public Object apply(Tuple o) {
        Object y = this.x.apply(o);
        if (y == null) {
            return null;
        }
        if (y instanceof Double) {
            return Math.abs((Double)y);
        }
        if (y instanceof Integer) {
            return Math.abs((Integer)y);
        }
        if (y instanceof Float) {
            return Float.valueOf(Math.abs(((Float)y).floatValue()));
        }
        if (y instanceof Long) {
            return Math.abs((Long)y);
        }
        throw new IllegalArgumentException("Invalid argument for abs(): " + y);
    }

    @Override
    public int applyAsInt(Tuple o) {
        return Math.abs(this.x.applyAsInt(o));
    }

    @Override
    public long applyAsLong(Tuple o) {
        return Math.abs(this.x.applyAsLong(o));
    }

    @Override
    public float applyAsFloat(Tuple o) {
        return Math.abs(this.x.applyAsFloat(o));
    }

    @Override
    public double applyAsDouble(Tuple o) {
        return Math.abs(this.x.applyAsDouble(o));
    }

    @Override
    public DataType type() {
        return this.x.type();
    }

    @Override
    public void bind(StructType schema) {
        this.x.bind(schema);
        if (!(this.x.type().isInt() || this.x.type().isLong() || this.x.type().isDouble() || this.x.type().isFloat())) {
            throw new IllegalStateException(String.format("Invalid expression: abs(%s)", this.x.type()));
        }
    }
}

