/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.IntStream;

public interface Index
extends Serializable {
    public int size();

    public int apply(int var1);

    public IntStream stream();

    default public int[] toArray() {
        return this.stream().toArray();
    }

    default public Index flatten(Index index) {
        int[] parent = this.stream().toArray();
        int[] child = index.stream().map(i -> parent[i]).toArray();
        return Index.of(child);
    }

    public static Index of(final int ... indices) {
        return new Index(){

            @Override
            public int size() {
                return indices.length;
            }

            @Override
            public int apply(int i) {
                return indices[i];
            }

            @Override
            public IntStream stream() {
                return Arrays.stream(indices);
            }
        };
    }

    public static Index of(boolean ... mask) {
        int[] indices = IntStream.range(0, mask.length).filter(i -> mask[i]).toArray();
        return Index.of(indices);
    }

    public static Index range(final int start, final int end) {
        return new Index(){

            @Override
            public int size() {
                return end - start;
            }

            @Override
            public int apply(int i) {
                return start + i;
            }

            @Override
            public IntStream stream() {
                return IntStream.range(start, end);
            }
        };
    }

    public static Index range(final Integer start, Integer end, final Integer step) {
        final int size = (end - start + step - 1) / step;
        return new Index(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public int apply(int i) {
                return start + i * step;
            }

            @Override
            public IntStream stream() {
                return IntStream.iterate(start, i -> i + step).limit(size);
            }
        };
    }
}

