/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.util.Strings;

public final class FloatArrayList
implements Serializable {
    private static final long serialVersionUID = 1L;
    float[] data;
    private int size;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(int capacity) {
        this.data = new float[capacity];
        this.size = 0;
    }

    public FloatArrayList(float[] values) {
        this(Math.max(values.length, 10));
        this.add(values);
    }

    public String toString() {
        String suffix = this.size() > 10 ? ", ...]" : "]";
        return this.stream().limit(10L).mapToObj(Strings::format).collect(Collectors.joining(", ", "[", suffix));
    }

    public DoubleStream stream() {
        return IntStream.range(0, this.size).mapToDouble(i -> this.data[i]);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            int newCap = Math.max(this.data.length << 1, capacity);
            float[] tmp = new float[newCap];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        if (this.data.length > this.size()) {
            this.data = this.toArray();
        }
    }

    public void add(float val) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = val;
    }

    public void add(float[] vals) {
        this.ensureCapacity(this.size + vals.length);
        System.arraycopy(vals, 0, this.data, this.size, vals.length);
        this.size += vals.length;
    }

    public float get(int index) {
        return this.data[index];
    }

    public void set(int index, float val) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.data[index] = val;
    }

    public void clear() {
        this.size = 0;
    }

    public float remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        float old = this.get(index);
        if (index == 0) {
            System.arraycopy(this.data, 1, this.data, 0, this.size - 1);
        } else if (this.size - 1 != index) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - (index + 1));
        }
        --this.size;
        return old;
    }

    public float[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public float[] toArray(float[] dest) {
        if (dest == null || dest.length < this.size()) {
            dest = new float[this.size];
        }
        System.arraycopy(this.data, 0, dest, 0, this.size);
        return dest;
    }
}

