/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import smile.linalg.Diag;
import smile.linalg.UPLO;
import smile.tensor.DenseMatrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;
import smile.tensor.Vector64;

class DenseMatrix64
extends DenseMatrix {
    final double[] data;

    private DenseMatrix64() {
        this.data = null;
    }

    public DenseMatrix64(double[] data, int m, int n, int ld, UPLO uplo, Diag diag) {
        super(MemorySegment.ofArray(data), m, n, ld, uplo, diag);
        this.data = data;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memory = MemorySegment.ofArray(this.data);
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float64;
    }

    @Override
    public double get(int i, int j) {
        return this.data[this.offset(i, j)];
    }

    @Override
    public void set(int i, int j, double x) {
        this.data[this.offset((int)i, (int)j)] = x;
    }

    @Override
    public void add(int i, int j, double x) {
        int n = this.offset(i, j);
        this.data[n] = this.data[n] + x;
    }

    @Override
    public void sub(int i, int j, double x) {
        int n = this.offset(i, j);
        this.data[n] = this.data[n] - x;
    }

    @Override
    public void mul(int i, int j, double x) {
        int n = this.offset(i, j);
        this.data[n] = this.data[n] * x;
    }

    @Override
    public void div(int i, int j, double x) {
        int n = this.offset(i, j);
        this.data[n] = this.data[n] / x;
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix64((double[])this.data.clone(), this.m, this.n, this.ld, this.uplo, this.diag);
    }

    @Override
    public Vector column(int j) {
        return Vector64.column(this.data, this.offset(0, j), this.m);
    }

    @Override
    public DenseMatrix submatrix(int i, int j, int k, int l) {
        if (i < 0 || i > this.m || k <= i || k > this.m || j < 0 || j > this.n || l <= j || l > this.n) {
            throw new IllegalArgumentException(String.format("Invalid submatrix range (%d:%d, %d:%d) of %d x %d", i, k, j, l, this.m, this.n));
        }
        if (i == 0 && j == 0) {
            return new DenseMatrix64(this.data, k, l, this.ld, this.uplo, this.diag);
        }
        int nrow = k - i;
        int ncol = l - j;
        DenseMatrix sub = this.zeros(nrow, ncol);
        for (int q = 0; q < ncol; ++q) {
            for (int p = 0; p < nrow; ++p) {
                sub.set(p, q, this.get(p + i, q + j));
            }
        }
        return sub;
    }
}

