/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import smile.util.Strings;

public record Neighbor<K, V>(K key, V value, int index, double distance) implements Comparable<Neighbor<K, V>>
{
    @Override
    public int compareTo(Neighbor<K, V> o) {
        int d = Double.compare(this.distance, o.distance);
        return d == 0 ? Integer.compare(this.index, o.index) : d;
    }

    @Override
    public String toString() {
        return String.format("Neighbor(%s[%d]: %s)", this.key, this.index, Strings.format(this.distance));
    }

    public static <T> Neighbor<T, T> of(T key, int index, double distance) {
        return new Neighbor<T, T>(key, key, index, distance);
    }
}

