/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;

public class IntHashSet {
    private static final int FREE_KEY = Integer.MIN_VALUE;
    private int[] keys;
    private final float loadFactor;
    private int threshold;
    private int size;
    private int mask;
    private static final int INT_PHI = -1640531527;

    public IntHashSet() {
        this(16, 0.75f);
    }

    public IntHashSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("Invalid fill factor: " + loadFactor);
        }
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Invalid initial capacity: " + initialCapacity);
        }
        this.loadFactor = loadFactor;
        int capacity = this.arraySize(initialCapacity, loadFactor);
        this.mask = capacity - 1;
        this.keys = new int[capacity];
        Arrays.fill(this.keys, Integer.MIN_VALUE);
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public boolean contains(int key) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("key cannot be 0x80000000");
        }
        int ptr = this.hash(key);
        int k;
        while ((k = this.keys[ptr]) != Integer.MIN_VALUE) {
            if (k == key) {
                return true;
            }
            ptr = ptr + 1 & this.mask;
        }
        return false;
    }

    public boolean add(int key) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("key cannot be 0x80000000");
        }
        int ptr = this.hash(key);
        while (true) {
            int k;
            if ((k = this.keys[ptr]) == Integer.MIN_VALUE) {
                this.keys[ptr] = key;
                if (++this.size >= this.threshold) {
                    this.rehash(this.keys.length * 2);
                }
                return true;
            }
            if (k == key) {
                return false;
            }
            ptr = ptr + 1 & this.mask;
        }
    }

    public boolean remove(int key) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("key cannot be 0x80000000");
        }
        int ptr = this.hash(key);
        int k;
        while ((k = this.keys[ptr]) != Integer.MIN_VALUE) {
            if (k == key) {
                this.keys[ptr] = Integer.MIN_VALUE;
                return true;
            }
            ptr = ptr + 1 & this.mask;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int[] a = new int[this.size];
        int i = 0;
        for (int k : this.keys) {
            if (k == Integer.MIN_VALUE) continue;
            a[i++] = k;
        }
        return a;
    }

    private void rehash(int newCapacity) {
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.mask = newCapacity - 1;
        int oldCapacity = this.keys.length;
        int[] oldKeys = this.keys;
        this.keys = new int[newCapacity];
        Arrays.fill(this.keys, Integer.MIN_VALUE);
        for (int i = 0; i < oldCapacity; ++i) {
            int oldKey = oldKeys[i];
            if (oldKey == Integer.MIN_VALUE) continue;
            this.add(oldKey);
        }
    }

    private long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    private int arraySize(int expected, float f) {
        long s = Math.max(2L, this.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException(String.format("Too large %d expected elements with load factor %.2f", expected, Float.valueOf(f)));
        }
        return (int)s;
    }

    private int hash(int x) {
        int h = x * -1640531527;
        return (h ^ h >> 16) & this.mask;
    }
}

