/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.io.HadoopInput;
import smile.io.LocalInputFile;

public class Parquet {
    private static final Logger logger = LoggerFactory.getLogger(Parquet.class);

    private Parquet() {
    }

    public static DataFrame read(Path path) throws IOException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(Path path, int limit) throws IOException {
        return Parquet.read(new LocalInputFile(path), limit);
    }

    public static DataFrame read(String path) throws IOException, URISyntaxException {
        return Parquet.read(path, Integer.MAX_VALUE);
    }

    public static DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return Parquet.read(HadoopInput.file(path), limit);
    }

    public static DataFrame read(InputFile file) throws IOException {
        return Parquet.read(file, Integer.MAX_VALUE);
    }

    public static DataFrame read(InputFile file, int limit) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)file);){
            PageReadStore store;
            ParquetMetadata footer = reader.getFooter();
            MessageType schema = footer.getFileMetaData().getSchema();
            StructType struct = Parquet.toSmileSchema(schema);
            logger.debug("The meta data of parquet file {}: {}", (Object)file, (Object)ParquetMetadata.toPrettyJSON((ParquetMetadata)footer));
            int nrow = (int)Math.min(reader.getRecordCount(), (long)limit);
            ArrayList<Tuple> rows = new ArrayList<Tuple>(nrow);
            while ((store = reader.readNextRowGroup()) != null) {
                long rowCount = store.getRowCount();
                MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
                RecordReader recordReader = columnIO.getRecordReader(store, (RecordMaterializer)new GroupRecordConverter(schema));
                int i = 0;
                while ((long)i < rowCount && rows.size() < nrow) {
                    rows.add(Tuple.of(Parquet.readRowGroup((Group)recordReader.read(), schema.getColumns(), struct), struct));
                    ++i;
                }
            }
            DataFrame dataFrame = DataFrame.of(rows);
            return dataFrame;
        }
    }

    private static Object[] readRowGroup(Group g, List<ColumnDescriptor> columns, StructType schema) {
        int length = schema.length();
        Object[] o = new Object[length];
        block20: for (int i = 0; i < length; ++i) {
            int rep = g.getFieldRepetitionCount(i);
            ColumnDescriptor column = columns.get(i);
            PrimitiveType primitiveType = column.getPrimitiveType();
            LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    if (rep == 1) {
                        o[i] = g.getBoolean(i, 0);
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    boolean[] a = new boolean[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBoolean(i, j);
                    }
                    o[i] = a;
                    continue block20;
                }
                case INT32: {
                    if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getInteger(i, 0);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        int[] a = new int[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getInteger(i, j);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            o[i] = BigDecimal.valueOf(g.getInteger(i, 0), scale);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = BigDecimal.valueOf(g.getInteger(i, j), scale);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = LocalDate.ofEpochDay(g.getInteger(i, 0));
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        LocalDate[] a = new LocalDate[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = LocalDate.ofEpochDay(g.getInteger(i, j));
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType;
                        if (timeType.getUnit() != LogicalTypeAnnotation.TimeUnit.MILLIS) {
                            throw new IllegalStateException("Invalid TimeUnit for INT32: " + timeType.getUnit());
                        }
                        if (rep == 1) {
                            o[i] = LocalTime.ofNanoOfDay(g.getInteger(i, 0) * 1000000);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        LocalTime[] a = new LocalTime[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = LocalTime.ofNanoOfDay(g.getInteger(i, j) * 1000000);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    throw new IllegalStateException("Invalid logical type for INT32: " + logicalType);
                }
                case INT64: {
                    if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getLong(i, 0);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        long[] a = new long[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getLong(i, j);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            o[i] = BigDecimal.valueOf(g.getLong(i, 0), scale);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = BigDecimal.valueOf(g.getLong(i, j), scale);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalType;
                        switch (timeType.getUnit()) {
                            case MILLIS: {
                                throw new IllegalStateException("Invalid TimeUnit for INT64: " + timeType.getUnit());
                            }
                            case MICROS: {
                                if (rep == 1) {
                                    o[i] = LocalTime.ofNanoOfDay(g.getLong(i, 0) * 1000L);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalTime[] a = new LocalTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    a[j] = LocalTime.ofNanoOfDay(g.getLong(i, j) * 1000L);
                                }
                                o[i] = a;
                                break;
                            }
                            case NANOS: {
                                if (rep == 1) {
                                    o[i] = LocalTime.ofNanoOfDay(g.getLong(i, 0));
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalTime[] a = new LocalTime[rep];
                                for (int j = 0; j < rep; ++j) {
                                    a[j] = LocalTime.ofNanoOfDay(g.getLong(i, j));
                                }
                                o[i] = a;
                            }
                        }
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                        ZoneId zone = timeType.isAdjustedToUTC() ? ZoneOffset.UTC : ZoneId.systemDefault();
                        switch (timeType.getUnit()) {
                            case MILLIS: {
                                int j;
                                if (rep == 1) {
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(g.getLong(i, 0)), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (j = 0; j < rep; ++j) {
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochMilli(g.getLong(i, j)), zone);
                                }
                                o[i] = a;
                                break;
                            }
                            case MICROS: {
                                int j;
                                if (rep == 1) {
                                    long micros = g.getLong(i, 0);
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochSecond(micros / 1000000L, (int)(micros % 100000L) * 1000), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (j = 0; j < rep; ++j) {
                                    long micros = g.getLong(i, j);
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochSecond(micros / 1000000L, (int)(micros % 100000L) * 1000), zone);
                                }
                                o[i] = a;
                                break;
                            }
                            case NANOS: {
                                int j;
                                if (rep == 1) {
                                    long nanos = g.getLong(i, 0);
                                    o[i] = LocalDateTime.ofInstant(Instant.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 100000000L)), zone);
                                    break;
                                }
                                if (rep <= 1) break;
                                LocalDateTime[] a = new LocalDateTime[rep];
                                for (j = 0; j < rep; ++j) {
                                    long nanos = g.getLong(i, j);
                                    a[j] = LocalDateTime.ofInstant(Instant.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 100000000L)), zone);
                                }
                                o[i] = a;
                            }
                        }
                        continue block20;
                    }
                    throw new IllegalStateException("Invalid logical type for INT64: " + logicalType);
                }
                case INT96: {
                    if (rep == 1) {
                        ByteBuffer buf = g.getInt96(i, 0).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                        long nanoOfDay = buf.getLong();
                        int julianDay = buf.getInt();
                        LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                        LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                        o[i] = LocalDateTime.of(date, time);
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    LocalDateTime[] a = new LocalDateTime[rep];
                    for (int j = 0; j < rep; ++j) {
                        ByteBuffer buf = g.getInt96(i, 0).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                        long nanoOfDay = buf.getLong();
                        int julianDay = buf.getInt();
                        LocalDate date = LocalDate.ofEpochDay(julianDay - 2440588);
                        LocalTime time = LocalTime.ofNanoOfDay(nanoOfDay);
                        a[j] = LocalDateTime.of(date, time);
                    }
                    o[i] = a;
                    continue block20;
                }
                case FLOAT: {
                    if (rep == 1) {
                        o[i] = Float.valueOf(g.getFloat(i, 0));
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    float[] a = new float[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getFloat(i, j);
                    }
                    o[i] = a;
                    continue block20;
                }
                case DOUBLE: {
                    if (rep == 1) {
                        o[i] = g.getDouble(i, 0);
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    double[] a = new double[rep];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getDouble(i, j);
                    }
                    o[i] = a;
                    continue block20;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    if (logicalType instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
                        if (rep == 1) {
                            byte[] bytes = g.getBinary(i, 0).getBytes();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                            long high = byteBuffer.getLong();
                            long low = byteBuffer.getLong();
                            o[i] = new UUID(high, low);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        UUID[] a = new UUID[rep];
                        for (int j = 0; j < rep; ++j) {
                            byte[] bytes = g.getBinary(i, j).getBytes();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                            long high = byteBuffer.getLong();
                            long low = byteBuffer.getLong();
                            a[j] = new UUID(high, low);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                        if (rep == 1) {
                            byte[] bytes = g.getBinary(i, 0).getBytes();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                            int months = byteBuffer.getInt();
                            int days = byteBuffer.getInt();
                            int millis = byteBuffer.getInt();
                            Duration duration = Duration.ofDays(days);
                            o[i] = duration.plusDays(months * 30).plusMillis(millis);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        Duration[] a = new Duration[rep];
                        for (int j = 0; j < rep; ++j) {
                            byte[] bytes = g.getBinary(i, j).getBytes();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                            int months = byteBuffer.getInt();
                            int days = byteBuffer.getInt();
                            int millis = byteBuffer.getInt();
                            Duration duration = Duration.ofDays(days);
                            a[j] = duration.plusDays(months * 30).plusMillis(millis);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            byte[] value = g.getBinary(i, 0).getBytes();
                            o[i] = new BigDecimal(new BigInteger(value), scale);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            byte[] value = g.getBinary(i, j).getBytes();
                            a[j] = new BigDecimal(new BigInteger(value), scale);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getString(i, 0);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        String[] a = new String[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getString(i, j);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (rep == 1) {
                        o[i] = g.getBinary(i, 0).getBytes();
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    byte[][] a = new byte[rep][];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBinary(i, j).getBytes();
                    }
                    o[i] = a;
                    continue block20;
                }
                case BINARY: {
                    if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
                        if (rep == 1) {
                            byte[] value = g.getBinary(i, 0).getBytes();
                            o[i] = new BigDecimal(new BigInteger(value), scale);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        BigDecimal[] a = new BigDecimal[rep];
                        for (int j = 0; j < rep; ++j) {
                            byte[] value = g.getBinary(i, j).getBytes();
                            a[j] = new BigDecimal(new BigInteger(value), scale);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation || logicalType instanceof LogicalTypeAnnotation.JsonLogicalTypeAnnotation) {
                        if (rep == 1) {
                            o[i] = g.getString(i, 0);
                            continue block20;
                        }
                        if (rep <= 1) continue block20;
                        String[] a = new String[rep];
                        for (int j = 0; j < rep; ++j) {
                            a[j] = g.getString(i, j);
                        }
                        o[i] = a;
                        continue block20;
                    }
                    if (rep == 1) {
                        o[i] = g.getBinary(i, 0).getBytes();
                        continue block20;
                    }
                    if (rep <= 1) continue block20;
                    byte[][] a = new byte[rep][];
                    for (int j = 0; j < rep; ++j) {
                        a[j] = g.getBinary(i, j).getBytes();
                    }
                    o[i] = a;
                }
            }
        }
        return o;
    }

    private static StructType toSmileSchema(MessageType schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (ColumnDescriptor column : schema.getColumns()) {
            fields.add(Parquet.toSmileField(column));
        }
        return DataTypes.struct(fields);
    }

    private static StructField toSmileField(ColumnDescriptor column) {
        String name = String.join((CharSequence)".", column.getPath());
        PrimitiveType primitiveType = column.getPrimitiveType();
        LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
        Type.Repetition repetition = primitiveType.getRepetition();
        switch (primitiveType.getPrimitiveTypeName()) {
            case BOOLEAN: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, DataTypes.BooleanType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, DataTypes.BooleanObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, DataTypes.BooleanArrayType);
                    }
                }
                break;
            }
            case INT32: {
                if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: {
                            return new StructField(name, DataTypes.IntegerType);
                        }
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.IntegerObjectType);
                        }
                        case REPEATED: {
                            return new StructField(name, DataTypes.IntegerArrayType);
                        }
                    }
                    break;
                }
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.DecimalType);
                        }
                    }
                    break;
                }
                if (logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.DateType);
                        }
                    }
                    break;
                }
                if (!(logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation)) break;
                switch (repetition) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return new StructField(name, DataTypes.TimeType);
                    }
                }
                break;
            }
            case INT64: {
                if (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: {
                            return new StructField(name, DataTypes.LongType);
                        }
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.LongObjectType);
                        }
                        case REPEATED: {
                            return new StructField(name, DataTypes.LongArrayType);
                        }
                    }
                    break;
                }
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.DecimalType);
                        }
                    }
                    break;
                }
                if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                    switch (repetition) {
                        case REQUIRED: 
                        case OPTIONAL: {
                            return new StructField(name, DataTypes.TimeType);
                        }
                    }
                    break;
                }
                if (!(logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) break;
                switch (repetition) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        return new StructField(name, DataTypes.DateTimeType);
                    }
                }
                break;
            }
            case INT96: {
                return new StructField(name, DataTypes.DateTimeType);
            }
            case FLOAT: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, DataTypes.FloatType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, DataTypes.FloatObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, DataTypes.FloatArrayType);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (repetition) {
                    case REQUIRED: {
                        return new StructField(name, DataTypes.DoubleType);
                    }
                    case OPTIONAL: {
                        return new StructField(name, DataTypes.DoubleObjectType);
                    }
                    case REPEATED: {
                        return new StructField(name, DataTypes.DoubleArrayType);
                    }
                }
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (logicalType instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.ObjectType);
                }
                if (logicalType instanceof LogicalTypeAnnotation.IntervalLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.ObjectType);
                }
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.DecimalType);
                }
                if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.StringType);
                }
                return new StructField(name, DataTypes.ByteArrayType);
            }
            case BINARY: {
                if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.DecimalType);
                }
                if (logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                    return new StructField(name, DataTypes.StringType);
                }
                return new StructField(name, DataTypes.ByteArrayType);
            }
        }
        throw new UnsupportedOperationException("Unsupported LogicalType " + logicalType + " for primitive type " + primitiveType);
    }
}

