/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.Vector;

public interface Feature {
    public StructField field();

    public Object apply(Tuple var1);

    default public double applyAsDouble(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public float applyAsFloat(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public int applyAsInt(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public long applyAsLong(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public boolean applyAsBoolean(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public byte applyAsByte(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public short applyAsShort(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public char applyAsChar(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    default public boolean isVariable() {
        return false;
    }

    default public BaseVector apply(DataFrame data) {
        StructField field = this.field();
        if (this.isVariable()) {
            return data.column(field.name);
        }
        int size = data.size();
        switch (field.type.id()) {
            case Integer: {
                int[] values = new int[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsInt((Tuple)data.get(i));
                }
                return IntVector.of(field, values);
            }
            case Long: {
                long[] values = new long[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsLong((Tuple)data.get(i));
                }
                return LongVector.of(field, values);
            }
            case Double: {
                double[] values = new double[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsDouble((Tuple)data.get(i));
                }
                return DoubleVector.of(field, values);
            }
            case Float: {
                float[] values = new float[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsFloat((Tuple)data.get(i));
                }
                return FloatVector.of(field, values);
            }
            case Boolean: {
                boolean[] values = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsBoolean((Tuple)data.get(i));
                }
                return BooleanVector.of(field, values);
            }
            case Byte: {
                byte[] values = new byte[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsByte((Tuple)data.get(i));
                }
                return ByteVector.of(field, values);
            }
            case Short: {
                short[] values = new short[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsShort((Tuple)data.get(i));
                }
                return ShortVector.of(field, values);
            }
            case Char: {
                char[] values = new char[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = this.applyAsChar((Tuple)data.get(i));
                }
                return CharVector.of(field, values);
            }
        }
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = this.apply((Tuple)data.get(i));
        }
        return Vector.of(field, values);
    }
}

