/*
 * Decompiled with CFR 0.152.
 */
package echo;

import echo.exception.FailureException;
import echo.output.NewlineFormatter;
import echo.parameter.PluginParameters;
import echo.util.FileUtil;
import java.io.IOException;

class MessageExtractor {
    private final FileUtil fileUtil;
    private final NewlineFormatter newlineFormatter;
    private final String message;
    private final String fromFile;
    private String originalMessage;

    public MessageExtractor(PluginParameters pluginParameters, FileUtil fileUtil) {
        this.fileUtil = fileUtil;
        this.newlineFormatter = new NewlineFormatter(pluginParameters);
        this.message = pluginParameters.getMessage();
        this.fromFile = pluginParameters.getFromFile();
    }

    public String getFormattedMessage() {
        this.extractMessage();
        return this.newlineFormatter.format(this.originalMessage);
    }

    private void extractMessage() {
        this.checkMissingMessage();
        if (this.message != null) {
            this.originalMessage = this.message;
        } else {
            try {
                this.originalMessage = this.fileUtil.getFromFile();
            }
            catch (IOException ex) {
                throw new FailureException(ex.getMessage(), ex);
            }
        }
    }

    private void checkMissingMessage() {
        if (this.message == null && this.fromFile == null) {
            throw new FailureException("There was nothing to output. Specify either message or fromFile");
        }
        if (this.message != null && this.fromFile != null) {
            throw new FailureException("Specify either message or fromFile, not both");
        }
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }
}

