/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.transaction.ReadCommittedSoftLockFactoryImpl;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.TransactionID;

public class ReadCommittedSoftLockImpl
implements SoftLock {
    private static final int PRIME = 31;
    private final ReadCommittedSoftLockFactoryImpl factory;
    private final TransactionID transactionID;
    private final Object key;
    private Element newElement;
    private final Element oldElement;
    private final ReentrantLock lock;
    private final ReentrantReadWriteLock freezeLock;
    private volatile boolean expired;

    ReadCommittedSoftLockImpl(ReadCommittedSoftLockFactoryImpl factory, TransactionID transactionID, Object key, Element newElement, Element oldElement) {
        this.factory = factory;
        this.transactionID = transactionID;
        this.key = key;
        this.newElement = newElement;
        this.oldElement = oldElement;
        this.lock = new ReentrantLock();
        this.freezeLock = new ReentrantReadWriteLock();
    }

    public Object getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(TransactionID currentTransactionId) {
        this.freezeLock.readLock().lock();
        try {
            if (this.transactionID.equals(currentTransactionId)) {
                Element element = this.newElement;
                return element;
            }
            Element element = this.oldElement;
            return element;
        }
        finally {
            this.freezeLock.readLock().unlock();
        }
    }

    public Element updateElement(Element newElement) {
        Element e = this.newElement;
        this.newElement = newElement;
        return e;
    }

    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    public void lock() {
        this.lock.lock();
    }

    public boolean tryLock(long ms) throws InterruptedException {
        return this.lock.tryLock(ms, TimeUnit.MILLISECONDS);
    }

    public void clearTryLock() {
        this.lock.unlock();
    }

    public void unlock() {
        this.lock.unlock();
        this.clear();
    }

    private boolean isLocked() {
        return this.lock.isLocked();
    }

    public void freeze() {
        if (!this.isLocked()) {
            throw new IllegalStateException("cannot freeze an unlocked soft lock");
        }
        this.freezeLock.writeLock().lock();
    }

    public Element getFrozenElement() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("cannot get frozen element of a soft lock which hasn't been frozen or hasn't expired");
        }
        if (this.transactionID.isDecisionCommit()) {
            return this.newElement;
        }
        return this.oldElement;
    }

    public void unfreeze() {
        this.freezeLock.writeLock().unlock();
    }

    private boolean isFrozen() {
        return this.freezeLock.isWriteLocked();
    }

    public boolean isExpired() {
        if (!this.expired) {
            this.expired = !this.isFrozen() && !this.isLocked();
        }
        return this.expired;
    }

    private void clear() {
        this.factory.clearSoftLock(this);
    }

    public boolean equals(Object object) {
        if (object instanceof ReadCommittedSoftLockImpl) {
            ReadCommittedSoftLockImpl other = (ReadCommittedSoftLockImpl)object;
            if (!this.transactionID.equals(other.transactionID)) {
                return false;
            }
            return this.key.equals(other.key);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31;
        hashCode *= this.transactionID.hashCode();
        return hashCode *= this.key.hashCode();
    }

    public String toString() {
        return "Soft Lock [clustered: false, isolation: rc, transactionID: " + this.transactionID + ", key: " + this.key + ", newElement: " + this.newElement + ", oldElement: " + this.oldElement + "]";
    }
}

