/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.search.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class GroupAction
extends AbstractFaxToMailAction<SearchUIModel, SearchToGroupUI, SearchToGroupUIHandler> {
    protected DemandeUIModel currentEmail;
    protected DemandeUIModel selectedEmail;

    public GroupAction(SearchToGroupUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.group.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        JXTable dataTable = ((SearchToGroupUI)this.getUI()).getDataTable();
        int rowIndex = dataTable.getSelectedRow();
        rowIndex = dataTable.convertRowIndexToModel(rowIndex);
        this.selectedEmail = ((DemandeTableModel)dataTable.getModel()).getEntry(rowIndex);
        this.currentEmail = this.getContext().getCurrentEmail();
        int i = JOptionPane.showConfirmDialog(null, I18n.t((String)"faxtomail.alert.groupConfirmation.message", (Object[])new Object[]{this.currentEmail.getTitle(), this.selectedEmail.getTitle()}), I18n.t((String)"faxtomail.alert.groupConfirmation.title", (Object[])new Object[0]), 0, 3);
        boolean result = i == 0;
        return result;
    }

    @Override
    public void doAction() throws Exception {
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        EmailService emailService = serviceContext.getEmailService();
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        Email email = emailService.groupEmails(this.currentEmail.getTopiaId(), this.selectedEmail.getTopiaId(), currentUser);
        this.currentEmail.fromEntity(email);
        this.currentEmail.setGroupedDemandes(email.getEmailGroup());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((SearchToGroupUIHandler)this.handler).showInformationMessage(I18n.t((String)"faxtomail.demande.group.successful", (Object[])new Object[0]));
        ((SearchToGroupUIHandler)this.handler).closeFrame();
    }
}

