/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.DemandeTableModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.util.pagination.PaginationResult;

public class LoadFolderEmailsAction
extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {
    private static final Log log = LogFactory.getLog(LoadFolderEmailsAction.class);

    public LoadFolderEmailsAction(DemandeListUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result;
        DemandeListUIModel model = (DemandeListUIModel)this.getModel();
        MailFolder folder = model.getSelectedFolder();
        if (folder == null) {
            result = false;
        } else {
            FaxToMailUIContext.FolderData currentFolderEmails = this.getContext().getCurrentFolderEmails();
            if (this.getContext().isUseFolderCache() && folder.equals(currentFolderEmails.getFolder())) {
                model.setEmails(new ArrayList<DemandeUIModel>(currentFolderEmails.getDemands()));
                PaginationResult<Email> paginationResult = currentFolderEmails.getPaginationResult();
                model.setPaginationParameter(paginationResult.getCurrentPage());
                model.setPaginationResult(paginationResult);
                result = false;
            } else {
                JXTable dataTable = ((DemandeListUI)this.getUI()).getDataTable();
                this.setActionDescription(I18n.t((String)"faxtomail.action.loadFolderEmails.tip", (Object[])new Object[]{folder.getName()}));
                this.getContext().getSwingSession().updateState();
                String columns = ((DemandeListUIHandler)this.handler).populateColumnModel(dataTable, false);
                dataTable.setName("dataTable" + columns);
                this.getContext().getSwingSession().add((Component)dataTable, true);
                ((DemandeListUIHandler)this.handler).updateEmailFilterWithContextEmailFilter();
                result = true;
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeListUIHandler handler = (DemandeListUIHandler)this.getHandler();
        DemandeListUIModel model = (DemandeListUIModel)this.getModel();
        MailFolder folder = model.getSelectedFolder();
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        List<MailField> columns = handler.getColumns();
        HashSet<MailField> fields = new HashSet<MailField>();
        if (columns != null) {
            fields.addAll(columns);
        }
        fields.add(MailField.TAKEN_BY);
        PaginationResult paginationResult = this.getContext().newServiceContext().getEmailService().getEmailForFolder(folder, currentUser, ((DemandeListUIModel)this.getModel()).getEmailFilter(), model.getPaginationParameter());
        List emails = paginationResult.getElements();
        if (log.isDebugEnabled()) {
            log.debug((Object)(emails.size() + " emails in folder " + folder.getName()));
        }
        ImmutableMap waitingStateById = Maps.uniqueIndex(this.getContext().getWaitingStateCache(), (Function)TopiaEntities.getTopiaIdFunction());
        ArrayList<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntityExcluding(email, Sets.newHashSet((Object[])new String[]{"mailFolder", "history"}));
            demand.recomputeValidRangeRows();
            demand.setMailFolder(folder);
            demand.setEditable(folder.isFolderWritable() && demand.getDemandStatus().isEditableStatus());
            WaitingState waitingState = email.getWaitingState();
            if (waitingState != null) {
                demand.setWaitingState((WaitingState)waitingStateById.get(waitingState.getTopiaId()));
            }
            demand.setValid(handler.isDemandeValid(demand));
            demands.add(demand);
        }
        if (this.getContext().isUseFolderCache()) {
            FaxToMailUIContext.FolderData currentFolderEmails = this.getContext().getCurrentFolderEmails();
            currentFolderEmails.setFolder(folder);
            currentFolderEmails.setDemands(demands);
            currentFolderEmails.setPaginationResult((PaginationResult<Email>)paginationResult);
        }
        model.setEmails(demands);
        model.setPaginationParameter(paginationResult.getCurrentPage());
        model.setPaginationResult((PaginationResult<Email>)paginationResult);
    }

    public void postSuccessAction() {
        JXTable dataTable;
        DemandeTableModel dataTableModel;
        int row;
        super.postSuccessAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        if (currentEmail != null && (row = (dataTableModel = (DemandeTableModel)(dataTable = ((DemandeListUI)this.getUI()).getDataTable()).getModel()).getRowIndex(currentEmail)) > 0) {
            dataTable.setRowSelectionInterval(row, row);
            dataTable.scrollRowToVisible(row);
        }
        ((DemandeListUIHandler)this.getHandler()).resetTimer();
    }

    protected void releaseAction() {
        super.releaseAction();
        ((DemandeListUI)this.getUI()).getNavigationTree().setEnabled(true);
    }
}

