package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SigningSettingsUI extends JSplitPane implements FaxToMailUI<SigningSettingsUIModel, SigningSettingsUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DELETE_BUTTON_ENABLED = "deleteButton.enabled";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SET_DEFAULT_BUTTON_ENABLED = "setDefaultButton.enabled";
    public static final String BINDING_SIGNING_PANEL_LAYOUT_SELECTED = "signingPanelLayout.selected";
    public static final String BINDING_TEXT_FIELD_TEXT = "textField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Xz1McRRRuFpbfMQQEE02qFkIQTDlAyvJC1MAGIriQFLumUuGgvTu90KnemXG6BwYpLP8E/wS9e7HKmyfLgxc9ePBi+S9Ylgevlu/NzM7szM7AUITDULzX73vvfd3v6+bbv0hR2mT6BXVdzXYMxVtM21p99uxx/QVrqIdMNmxuKdMm/k9PgRT2yIge2qUit/cqGL4YhC+WzZZlGszoiF6pkGGpjgWTB4wpRW7FIxpSLlZD94prOXYbNSwqDfXrf/4ufKV/+U2BENeC6iahldJ5UVEnfRVS4Loi45DpkC4KauxDGTY39qHeK2grCyrlDm2xz8gXZKBC+i1qA5giM/lb9jC8eNdS5FXJ9w3IUAUa4Jd8Qg0mFFlrmC2taVOjwWlTMFdrUleZLcqF5nBNHsFSrWEaClJoNrPEsVaN43y8aVleln5Fii1TR9BHlwfdRqQIeeiQCq5TaE+RuzGiQ0eAW8Xv07YxQhgP+vf6rtBj0wE248fPByhTW/f999ZdFQEMzNZoXbAlRa6nRHk+XDkUBlwJMsoKrSMr47ixbrB+yzPiyskwYMxgRwERa1AdEEQmYjG+NR40EmSpcAkNXYvnAFt89eDslkfAUrIczxqvf7STMbTdxs90kpBl/PM1/MxG22XA0Q07fB0/c3HnBmcCJmAqVkSNucpzJAIU2DPRVDtIkckuNKw9vv6aYYaHTYDSMD0Ene2iaTml7dEGnGsmor24hZ93Qv+wpIcs0zsmGcxqkzpCZa4ZhaPPVAqGTd6IHT2QLy2Sr0hfevZI0XbADGd1r1vxdsHla931hNYhoOf9b2ri9x/+/H6jLXBXIfdk6tIOfQbhsWzTYrbimPqqr26O4mJxm1ore2RIepR74n0zpbBq4IbiIJ93ljUM1z6k8gAgigN//PjT1Ke/9ZLCBhkWJtU3KK7fhFNwYAMLptBd64MHXkWjR4PwHcPaoJYWdXnLae2aR2XTQSEt3FtygYGbKQyEZdSHfv53ovrdgzYLBajqRubyiInic9LPDcEN5gl9oOGpwj5iSeboZqTVaepNQL+n1hg1NrhQzMapA+Gvm2umG+jTNi4ZxSUJR9n7PkrjpA8nBzQwEue2YGky0GFN4NS5DmJ8hFFBsqS4Wedk64WxgJ3iprGJuk96qY7X3yfUsgRvUHSsem5FqielC98ePrTUdkL99NG0BpJYOgWVVKYpatyqeS0vn9WyD6ZFWqwpbqVR0CXX57EAnA/KQHQUefek5N/5eIU57HFz3rs9tX2m2soUoM8vlKbfKxmOEAul07RKUu62HLUE+z93Fhko1dmHIJL5/OlmTkpZfeJYzGe0GF0aL6kzXHJGZ+GV81I6w2OX2Vl4geWYogFm4PTD8Sk2qYBmyMSBafPPYRyoWBWQreU9E2/A4cJBKcNYKGooqZXXd2rruzgLQblvn7nvpt8BTkImSd1XaY4OguwLOUbQv2gT0tHftsZH+sxuYnhZ4xy7189rpNi5FdXsjY9GtzQ3F6ziEh63vMmZDl6wRi9YLr2HK56UkKg3czSGL44ETX2+LVVia5eQ2CrA5tLYuznrztqOjmfUhTbj/klIczXx1Fr31+Rh/a0c1es+doL4gdCcyv3zy3Af9pNrB7T8PWReccnX6oW2Yi7XXJxeSBP8p3FSE9rWVMqfXoLyhx5wLrrzKJBfZ6YCdb77c9w7/SL4N/aV+3CSaanODR2yvd+F3YPfmXMR0fwLfn5NR7gDCP8D3Jy6eLgRAAA=";
    private static final Log log = LogFactory.getLog(SigningSettingsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected JButton deleteButton;
    protected final SigningSettingsUIHandler handler = createHandler();
    protected SigningSettingsUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedSigningName",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    protected JButton newSigningButton;
    protected JLabel noSigningSelected;
    protected JButton saveButton;
    protected JButton setDefaultButton;
    protected JList<Stamp> signingList;
    protected JPanel signingPanel;
    protected CardLayout2Ext signingPanelLayout;
    protected SigningSettingsUI signingSettingsPanel = this;
    protected JLabel signingsLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedSigningText",  editorName = "textField")
    protected JTextPane textField;
    protected JLabel textLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<SigningSettingsUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SigningSettingsUI(int param0) {
        super(param0);
        $initialize();
    }

    public SigningSettingsUI(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SigningSettingsUI(int param0, boolean param1, Component param2, Component param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SigningSettingsUI(JAXXContext parentContext, int param1, boolean param2, Component param3, Component param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SigningSettingsUI(int param0, Component param1, Component param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SigningSettingsUI(JAXXContext parentContext, int param1, Component param2, Component param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SigningSettingsUI(int param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SigningSettingsUI(JAXXContext parentContext, int param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SigningSettingsUI() {
        $initialize();
    }

    public SigningSettingsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "selectedSigningName");
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "selectedSigningText");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JButton getDeleteButton() {
        return deleteButton;
    }

    public SigningSettingsUIHandler getHandler() {
        return handler;
    }

    public SigningSettingsUIModel getModel() {
        return model;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public JButton getNewSigningButton() {
        return newSigningButton;
    }

    public JLabel getNoSigningSelected() {
        return noSigningSelected;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JButton getSetDefaultButton() {
        return setDefaultButton;
    }

    public JList<Stamp> getSigningList() {
        return signingList;
    }

    public JPanel getSigningPanel() {
        return signingPanel;
    }

    public CardLayout2Ext getSigningPanelLayout() {
        return signingPanelLayout;
    }

    public JLabel getSigningsLabel() {
        return signingsLabel;
    }

    public JTextPane getTextField() {
        return textField;
    }

    public JLabel getTextLabel() {
        return textLabel;
    }

    public SwingValidator<SigningSettingsUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSigningPanel() {
        if (!allComponentsCreated) {
            return;
        }
        signingPanel.add($Table1, "true");
        signingPanel.add(noSigningSelected, "false");
    }

    protected void addChildrenToSigningSettingsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, JSplitPane.LEFT);
        add($JPanel0, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.signings.settings.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.signings.settings.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createDeleteButton() {
        $objectMap.put("deleteButton", deleteButton = new JButton());
        
        deleteButton.setName("deleteButton");
        deleteButton.setText(t("faxtomail.signings.settings.action.delete"));
        deleteButton.setToolTipText(t("faxtomail.signings.settings.action.delete.tip"));
        deleteButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.DeleteSigningAction.class );
    }

    protected SigningSettingsUIHandler createHandler() {
        return new SigningSettingsUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SigningSettingsUIModel.class));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(t("faxtomail.signings.settings.name.label"));
    }

    protected void createNewSigningButton() {
        $objectMap.put("newSigningButton", newSigningButton = new JButton());
        
        newSigningButton.setName("newSigningButton");
        newSigningButton.setToolTipText(t("faxtomail.signings.settings.action.newSigning.tip"));
        newSigningButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.NewSigningAction.class );
    }

    protected void createNoSigningSelected() {
        $objectMap.put("noSigningSelected", noSigningSelected = new JLabel());
        
        noSigningSelected.setName("noSigningSelected");
        noSigningSelected.setEnabled(false);
        noSigningSelected.setText(t("faxtomail.signings.settings.noSelection.label"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("faxtomail.signings.settings.action.save"));
        saveButton.setToolTipText(t("faxtomail.signings.settings.action.save.tip"));
        saveButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.SaveSigningAction.class );
    }

    protected void createSetDefaultButton() {
        $objectMap.put("setDefaultButton", setDefaultButton = new JButton());
        
        setDefaultButton.setName("setDefaultButton");
        setDefaultButton.setText(t("faxtomail.signings.settings.action.default"));
        setDefaultButton.setToolTipText(t("faxtomail.signings.settings.action.default.tip"));
        setDefaultButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.content.reply.actions.SetDefaultSigningAction.class );
    }

    protected void createSigningList() {
        $objectMap.put("signingList", signingList = new JList<Stamp>());
        
        signingList.setName("signingList");
    }

    protected void createSigningPanel() {
        $objectMap.put("signingPanel", signingPanel = new JPanel());
        
        signingPanel.setName("signingPanel");
        signingPanel.setLayout( signingPanelLayout );
    }

    protected void createSigningPanelLayout() {
        $objectMap.put("signingPanelLayout", signingPanelLayout = new CardLayout2Ext(this, "signingPanel"));
    }

    protected void createSigningsLabel() {
        $objectMap.put("signingsLabel", signingsLabel = new JLabel());
        
        signingsLabel.setName("signingsLabel");
        signingsLabel.setText(t("faxtomail.signings.settings.label"));
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextPane());
        
        textField.setName("textField");
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createTextLabel() {
        $objectMap.put("textLabel", textLabel = new JLabel());
        
        textLabel.setName("textLabel");
        textLabel.setText(t("faxtomail.signings.settings.text.label"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SigningSettingsUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSigningSettingsPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(signingsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(newSigningButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(signingList, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(signingPanel, BorderLayout.CENTER);
        $JPanel0.add($JPanel1, BorderLayout.SOUTH);
        addChildrenToSigningPanel();
        // inline complete setup of $Table1
        $Table1.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(textLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(textField), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(cancelButton);
        $JPanel1.add(saveButton);
        $JPanel1.add(setDefaultButton);
        $JPanel1.add(deleteButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        newSigningButton.setIcon(SwingUtil.createActionIcon("add"));
        noSigningSelected.setHorizontalAlignment( SwingConstants.CENTER );
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        setDefaultButton.setIcon(SwingUtil.createActionIcon("default"));
        deleteButton.setIcon(SwingUtil.createActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("signingSettingsPanel", signingSettingsPanel);
        createModel();
        createValidator();
        createSigningPanelLayout();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSigningsLabel();
        createNewSigningButton();
        createSigningList();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSigningPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createNameLabel();
        createNameField();
        createTextLabel();
        createTextField();
        createNoSigningSelected();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createCancelButton();
        createSaveButton();
        createSetDefaultButton();
        createDeleteButton();
        // inline creation of signingSettingsPanel
        setName("signingSettingsPanel");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIGNING_PANEL_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSigning", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    signingPanelLayout.setSelected( String.valueOf(model.getSelectedSigning() != null) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSigning", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSigningName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField,  model.getSelectedSigningName() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSigningName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSigningText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(textField,  model.getSelectedSigningText() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSigningText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSigning", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("modified", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && validator != null) {
                    saveButton.setEnabled( model.getSelectedSigning() != null && model.isModified() && validator.isValid() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSigning", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("modified", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SET_DEFAULT_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("setDefaultButtonEnabled", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && model != null) {
                    setDefaultButton.setEnabled( model.isSetDefaultButtonEnabled() && validator.isValid() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("setDefaultButtonEnabled", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSigning", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteButton.setEnabled( model.getSelectedSigning() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSigning", this);
                }
            }
        });
    }

}